package xmlUtil;

import daruma.xml.UniversalName;
import daruma.xml.QName;
import daruma.xml.util.NodeUtil;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XMLParseErrorException;
import daruma.xml.handler.XSAXDefaultHandler;
import daruma.util.CloseIgnoreInputStream;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathConstants;
import javax.xml.transform.TransformerException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;

import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.InputSource;

import java.io.InputStream;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;


public class  XMLUtil
{
	static	public	List<UniversalName>	getUniversalNamesFromXPathQName
						  ( String  xPathString ,
						    InputStream  in )
						throws XMLParseErrorException ,
						       XPathExpressionException
	{
		Document	doc;

		try
		{
			doc = XMLFormatConverter.streamToDOMDocument( in );
		}
		catch( TransformerException  e )
		{
			throw new XMLParseErrorException( e );
		}

		NodeList	elementList;

		XPath	xPath = XPathFactory.newInstance().newXPath();

		try
		{
			elementList = (NodeList)xPath.evaluate
					( xPathString ,
					  doc ,
					  XPathConstants.NODESET );
		}
		catch( XPathExpressionException  e )
		{
			e.printStackTrace();
			throw e;
		}


		List<UniversalName>	names = new ArrayList<UniversalName>();

		for ( int  i = 0  ;  i < elementList.getLength()  ;  i ++ )
		{
			Element	e = (Element)elementList.item(i);

			QName	qName = new QName( e.getTextContent() );

			if ( ! qName.isValid() )
			{
				throw new XMLParseErrorException
				  ( "invalid QName [" + qName + "]" );
			}

			String	namespaceURI = NodeUtil.lookupNamespaceURI
						( e , qName.getPrefix() );

			names.add( new UniversalName
				   ( namespaceURI ,
				     qName.getLocalName() ) );
		}

		return( names );
	}


	static	public	XMLReader	createSAXParser()
					  throws ParserConfigurationException ,
						 SAXException
	{
		SAXParserFactory	f = SAXParserFactory.newInstance();
		f.setNamespaceAware( true );

		XMLReader	parser;

		try
		{
			parser = f.newSAXParser().getXMLReader();
		}
		catch( ParserConfigurationException  e )
		{
			throw e;
		}
		catch( SAXException  e )
		{
			throw e;
		}

		return( parser );
	}


	static	public	void	handleXMLInputStream
					( XSAXDefaultHandler  handler ,
					  XMLReader  parser ,
					  InputStream  in )
					throws SAXException ,
					       IOException
	{
		parser.setContentHandler( handler );
		parser.setErrorHandler( handler );

		parser.parse( new InputSource
			      ( new CloseIgnoreInputStream( in ) ) );
	}
}
