/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.DrmGeometry;
import daruma.geometry.DrmPoint;
import daruma.geometry.OgcGeometryFactory;
import daruma.geometry.TransformationException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrmLineString
extends DrmGeometry {
    private List<DrmPoint> points = new ArrayList<DrmPoint>();

    public void add(DrmPoint point) {
        this.points.add(point);
    }

    public List<DrmPoint> getPoints() {
        return this.points;
    }

    public DrmPoint get(int index) {
        return this.points.get(index);
    }

    @Override
    public DrmLineString transform(CoordinateSystemTransformation trans) throws TransformationException {
        DrmLineString ret = new DrmLineString();
        for (DrmPoint p : this.points) {
            ret.add(trans.transform(p));
        }
        return ret;
    }

    public LineString genGeometry(OgcGeometryFactory geoFactory) {
        CoordinateSequence coords = geoFactory.newCoords(this.points.size(), 2);
        int i = 0;
        for (DrmPoint point : this.points) {
            if (point.getDimension() == 3) {
                OgcGeometryFactory.setCoordinate3D(coords, i, point.getX(), point.getY(), point.getZ());
            } else {
                OgcGeometryFactory.setCoordinate2D(coords, i, point.getX(), point.getY());
            }
            ++i;
        }
        return geoFactory.createLineString(coords);
    }
}

