/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.CoordinateSystemTransformationDictionary;
import daruma.geometry.DrmGeometry;
import daruma.geometry.EulerAngles;
import daruma.geometry.TransformationException;
import daruma.util.EqualChecker;
import daruma.util.LogWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationContext {
    private TransformationType transformationType;
    private CoordinateSystem targetCoord;
    private CoordinateSystemTransformationDictionary coordTransDictionary = null;

    public TransformationContext() {
        this.transformationType = TransformationType.Conv;
        this.targetCoord = null;
    }

    public TransformationContext(TransformationType transformationType, CoordinateSystem targetCoord) {
        this.transformationType = transformationType;
        this.targetCoord = targetCoord;
    }

    public TransformationType getTransformationType() {
        return this.transformationType;
    }

    public void setTransformationType(TransformationType type) {
        this.transformationType = type;
    }

    public CoordinateSystem getTargetCoordinateSystem() {
        return this.targetCoord;
    }

    public void setCoordTransDictionary(CoordinateSystemTransformationDictionary dictionary) {
        this.coordTransDictionary = dictionary;
    }

    public DrmGeometry transform(DrmGeometry geom) throws TransformationException {
        if (this.targetCoord == null ? geom.getSrsName() == null : EqualChecker.equals(this.targetCoord.getSrsName(), geom.getSrsName())) {
            return geom;
        }
        List<CoordinateSystemTransformation> transPath = TransformationContext.search(this.coordTransDictionary, new CoordinateSystem(geom.getSrsName()), this.targetCoord);
        if (transPath == null) {
            throw new TransformationException("no route to transform");
        }
        for (CoordinateSystemTransformation trans : transPath) {
            geom = geom.transform(trans);
        }
        return geom;
    }

    public EulerAngles transform(EulerAngles angles) throws TransformationException {
        if (this.targetCoord == null ? angles.getSrsName() == null : EqualChecker.equals(this.targetCoord.getSrsName(), angles.getSrsName())) {
            return angles;
        }
        List<CoordinateSystemTransformation> transPath = TransformationContext.search(this.coordTransDictionary, new CoordinateSystem(angles.getSrsName()), this.targetCoord);
        if (transPath == null) {
            throw new TransformationException("no route to transform");
        }
        for (CoordinateSystemTransformation trans : transPath) {
            angles = trans.transform(angles);
        }
        return angles;
    }

    public static List<CoordinateSystemTransformation> search(CoordinateSystemTransformationDictionary dictionary, CoordinateSystem sourceCS, CoordinateSystem targetCS) {
        assert (!sourceCS.equals(targetCS));
        LogWriter.qwrite("DEBUG", "Entering search, [", sourceCS.getSrsName(), "] to [", targetCS.getSrsName(), "]");
        LinkedList<CoordinateSystemTransformation> ret = new LinkedList<CoordinateSystemTransformation>();
        CoordinateSystemTransformation trans = dictionary.get(sourceCS, targetCS);
        if (trans != null) {
            LogWriter.qwrite("DEBUG", "route found!!");
            ret.add(trans);
            return ret;
        }
        Map<CoordinateSystem, CoordinateSystemTransformation> nextCandicates = dictionary.getTransFrom(sourceCS);
        if (nextCandicates == null) {
            LogWriter.qwrite("DEBUG", "no candidates!!");
            return null;
        }
        for (Map.Entry<CoordinateSystem, CoordinateSystemTransformation> c : nextCandicates.entrySet()) {
            CoordinateSystem nextTarget = c.getKey();
            CoordinateSystemTransformation tr = c.getValue();
            CoordinateSystemTransformationDictionary dic = dictionary.clone();
            dic.remove(tr);
            List<CoordinateSystemTransformation> path = TransformationContext.search(dic, nextTarget, targetCS);
            if (path == null) continue;
            LogWriter.qwrite("DEBUG", "path found!!");
            ret.add(tr);
            ret.addAll(path);
            return ret;
        }
        LogWriter.qwrite("DEBUG", "path not found!!");
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransformationType {
        NoConv,
        Conv,
        Selective;

    }
}

