/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition;

import daruma.geometry.TransformationContext;
import daruma.sql.SQLDataType;
import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.ElementInfo;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.XMLSchemaElementDefinition;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.SimpleXPath;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositorTypeDefinition
extends TypeDefinition {
    private List<Entry> entries = new ArrayList<Entry>();

    public AbstractCompositorTypeDefinition() {
        super(true, true);
    }

    @Override
    public final SQLDataType getSingleSQLDataType() {
        return null;
    }

    protected final List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public List<TableColumnDefinition> getCompositeSQLDataType(StorageManager storage, SimpleXPath path, ElementInfo elementInfo) throws TypeException {
        ArrayList<TableColumnDefinition> ret = new ArrayList<TableColumnDefinition>();
        for (Entry e : this.getEntries()) {
            if (e.isCompositeEntry()) {
                TypeDefinition d = e.getCompositeEntry();
                ret.addAll(d.getCompositeSQLDataType(storage, path, elementInfo));
                continue;
            }
            TypeDefinition type = null;
            try {
                type = storage.getTypeDefinition(e.getAtomEntry().getTypeName());
            }
            catch (StorageException se) {
                throw new TypeException(se);
            }
            ElementName elementName = e.getAtomEntry().getElementName();
            SimpleXPath childPrefixSimpleXPath = new SimpleXPath(path);
            childPrefixSimpleXPath.add(elementName);
            if (!type.isSQLMultiColumn()) {
                String shortXPathString;
                try {
                    shortXPathString = storage.getShortXPathStringForDB(childPrefixSimpleXPath);
                }
                catch (StorageException se) {
                    throw new TypeException(se);
                }
                LogWriter.qwrite("DEBUG", "single = [", childPrefixSimpleXPath, "], name = [", e.getAtomEntry().getElementName(), "], type name = [", e.getAtomEntry().getTypeName(), "], type = [", e.getAtomEntry().getType().getClass());
                if (elementInfo != null) {
                    elementInfo.registerSubElement(childPrefixSimpleXPath, e.getAtomEntry().getType());
                }
                ret.add(new TableColumnDefinition(shortXPathString, type.getSingleSQLDataType(), e.getAtomEntry()));
                continue;
            }
            LogWriter.qwrite("DEBUG", "multi column prefix = [", childPrefixSimpleXPath, "]");
            List<TableColumnDefinition> defList = type.getCompositeSQLDataType(storage, childPrefixSimpleXPath, elementInfo);
            for (TableColumnDefinition def : defList) {
                def.setElementDefinition(e.getAtomEntry());
            }
            ret.addAll(defList);
        }
        return ret;
    }

    public final void addChild(XMLSchemaElementDefinition def) {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ".addChild():");
        LogWriter.qwrite("DEBUG", " typeName = [", def.getTypeName(), "],", " elementName = [", def.getElementName(), "]");
        this.entries.add(new Entry(def));
    }

    public void addChild(TypeDefinition typeDefinition) {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ".addChild():");
        LogWriter.qwrite("DEBUG", " class = [", typeDefinition.getClass().getName(), "]");
        this.entries.add(new Entry(typeDefinition));
    }

    @Override
    public abstract Pair<TypedInstance, Integer> createInstance(Element var1, ElementName var2, SimpleXPath var3, StorageManager var4, int var5, InstanceParseContext var6) throws TypeException;

    @Override
    public int convertToXMLElement(Element element, Document doc, StorageManager storage, TransformationContext trans, List<TableColumn> columns, int index, long id) throws TypeException {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ".convertToXMLElement()");
        int columnIndex = index;
        for (Entry e : this.getEntries()) {
            LogWriter.qwrite("DEBUG", "column index = ", columnIndex);
            if (e.isCompositeEntry()) {
                columnIndex = e.getCompositeEntry().convertToXMLElement(element, doc, storage, trans, columns, columnIndex, id);
                continue;
            }
            XMLSchemaElementDefinition a = e.getAtomEntry();
            TypeName childTypeName = a.getTypeName();
            ElementName childElementName = a.getElementName();
            TypeDefinition childType = a.getType();
            Element child = doc.createElementNS(childElementName.getNamespace(), childElementName.getLocalName());
            TableColumn c = columns.get(columnIndex);
            boolean shouldSkip = childType.shouldSkipColumns(columns, columnIndex);
            LogWriter.qwrite("DEBUG", "element = ", childTypeName);
            LogWriter.qwrite("DEBUG", "type = ", childType.getClass());
            LogWriter.qwrite("DEBUG", "skip? ", shouldSkip);
            if (!childType.isXMLComplexType() && !childType.isSQLMultiColumn()) {
                if (!shouldSkip) {
                    element.appendChild(child);
                    String value = columns.get(columnIndex).getValue();
                    child.appendChild(doc.createTextNode(value));
                }
                ++columnIndex;
            } else if (shouldSkip) {
                columnIndex += childType.getCompositeSQLDataType(storage, null, null).size();
            } else {
                element.appendChild(child);
                columnIndex = childType.convertToXMLElement(child, doc, storage, trans, columns, columnIndex, id);
            }
            LogWriter.qwrite("DEBUG", "");
        }
        return columnIndex;
    }

    public void debugPrint() {
        for (Entry e : this.entries) {
            if (e.isCompositeEntry()) {
                LogWriter.qwrite("DEBUG", "composite, ");
                TypeDefinition t = e.getCompositeEntry();
                LogWriter.qwrite("DEBUG", t.getClass().getName());
                continue;
            }
            LogWriter.qwrite("DEBUG", "atomic: ", e.getAtomEntry().getTypeName(), ": ", e.getAtomEntry().getElementName());
        }
    }

    public static class Entry {
        private XMLSchemaElementDefinition atom;
        private TypeDefinition composite;

        protected Entry(XMLSchemaElementDefinition def) {
            this.atom = def;
            this.composite = null;
        }

        protected Entry(TypeDefinition compositeEntry) {
            this.atom = null;
            this.composite = compositeEntry;
        }

        public boolean isCompositeEntry() {
            return this.composite != null;
        }

        public XMLSchemaElementDefinition getAtomEntry() {
            return this.atom;
        }

        public TypeDefinition getCompositeEntry() {
            return this.composite;
        }
    }
}

