/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.geometry.TransformationContext;
import daruma.sql.SQLDataType;
import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.ElementInfo;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.AbstractCompositorTypeDefinition;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.XMLSchemaElementDefinition;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceTypeDefinition
extends AbstractCompositorTypeDefinition {
    @Override
    public List<TableColumnDefinition> getCompositeSQLDataType(StorageManager storage, SimpleXPath path, ElementInfo elementInfo) throws TypeException {
        String indexColumnName;
        ArrayList<TableColumnDefinition> ret = new ArrayList<TableColumnDefinition>();
        if (path == null) {
            indexColumnName = ColumnNameFactory.getTopLevelElementColumnName();
        } else {
            SimpleXPath indexPath = new SimpleXPath(path);
            try {
                indexColumnName = storage.getShortXPathStringForDB(indexPath);
            }
            catch (StorageException e) {
                throw new TypeException(e);
            }
        }
        ret.add(new TableColumnDefinition(ColumnNameFactory.getCoiceElementIndexColumnName(indexColumnName), new SQLDataType("int", Integer.class)));
        List<TableColumnDefinition> childColumns = super.getCompositeSQLDataType(storage, path, elementInfo);
        if (!this.checkDeterministic(childColumns)) {
            throw new TypeException("ambiguos model, must be deterministic");
        }
        ret.addAll(childColumns);
        return ret;
    }

    private boolean checkDeterministic(List<TableColumnDefinition> columnDefinitions) {
        HashSet<String> columnNameDictionary = new HashSet<String>();
        for (TableColumnDefinition def : columnDefinitions) {
            String c = def.getColumnName();
            if (columnNameDictionary.contains(c)) {
                return false;
            }
            columnNameDictionary.add(c);
        }
        return true;
    }

    @Override
    public Pair<TypedInstance, Integer> createInstance(Element element, ElementName topLevelElement, SimpleXPath path, StorageManager storage, int elementIndex, InstanceParseContext parseContext) throws TypeException {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": createInstance()");
        LogWriter.qwrite("DEBUG", "elementIndex = ", elementIndex);
        LogWriter.qwrite("DEBUG", "--");
        super.debugPrint();
        LogWriter.qwrite("DEBUG", "--");
        LogWriter.qwrite("DEBUG", element);
        ArrayList<TableColumn> columnList = new ArrayList<TableColumn>();
        SimpleXPath columnPathBase = path != null ? new SimpleXPath(path, new UniversalName(element)) : path;
        List<TableColumnDefinition> indexColummns = this.getCompositeSQLDataType(storage, columnPathBase, null);
        TableColumn choiceElementIndex = new TableColumn(indexColummns.get(0), "0");
        columnList.add(choiceElementIndex);
        NodeList childNodes = element.getChildNodes();
        int nThChildNode = elementIndex;
        int foundDataIndex = -1;
        for (int i = 0; i < super.getEntries().size(); ++i) {
            List<TableColumnDefinition> def;
            TypeDefinition type;
            AbstractCompositorTypeDefinition.Entry entry = super.getEntries().get(i);
            if (entry.isCompositeEntry()) {
                LogWriter.qwrite("DEBUG", "next entry = composite, ", entry.getCompositeEntry().getClass().getName());
            } else {
                LogWriter.qwrite("DEBUG", "next entry = atomic");
            }
            if (entry.isCompositeEntry()) {
                Pair<TypedInstance, Integer> r;
                try {
                    r = entry.getCompositeEntry().createInstance(element, topLevelElement, path, storage, nThChildNode, parseContext);
                }
                catch (TypeException e) {
                    continue;
                }
                columnList.addAll(r.getFirst().getColumns());
                LogWriter.qwrite("DEBUG", "nThChildNode updated", " from ", nThChildNode, " to ", r.getSecond());
                nThChildNode = r.getSecond();
                break;
            }
            Node n = null;
            while (true) {
                if (nThChildNode >= childNodes.getLength()) {
                    LogWriter.qwrite("DEBUG", "child index = ", nThChildNode, ", ", "number of child nodes = ", childNodes.getLength());
                    throw new TypeException("too few child elements of " + new ElementName(element).toString());
                }
                n = childNodes.item(nThChildNode);
                if (n instanceof Element) break;
                ++nThChildNode;
            }
            Element childElement = (Element)n;
            ElementName childElementName = new ElementName(childElement);
            LogWriter.qwrite("DEBUG", "tag[", nThChildNode, "] = [", childElementName.toString(), "]");
            ElementName candidateElementName = entry.getAtomEntry().getElementName();
            LogWriter.qwrite("DEBUG", "candidate element = [", candidateElementName, "]");
            boolean dataExists = true;
            if (childElementName.equals(candidateElementName)) {
                foundDataIndex = i;
            } else {
                dataExists = false;
            }
            TypeName typeName = entry.getAtomEntry().getTypeName();
            LogWriter.qwrite("DEBUG", "typeName = [", typeName, "]");
            try {
                type = storage.getTypeDefinition(typeName);
            }
            catch (StorageException se) {
                throw new TypeException(se);
            }
            LogWriter.qwrite("DEBUG", "type.class = ", type.getClass().getName());
            SimpleXPath p = new SimpleXPath(path);
            if (path != null) {
                p.add(new UniversalName(element));
            }
            TypedInstance obj = null;
            if (dataExists) {
                try {
                    obj = type.createInstance(childElement, topLevelElement, p, storage, 0, parseContext).getFirst();
                }
                catch (TypeException e) {
                    throw new TypeException(e.getMessage(), e);
                }
                columnList.addAll(obj.getColumns());
                continue;
            }
            p.add(candidateElementName);
            if (type.isSQLMultiColumn()) {
                def = type.getCompositeSQLDataType(storage, p, null);
            } else {
                String columnName;
                try {
                    columnName = storage.getShortXPathStringForDB(p);
                }
                catch (StorageException e) {
                    throw new TypeException(e.getMessage(), e);
                }
                def = new ArrayList<TableColumnDefinition>();
                def.add(new TableColumnDefinition(columnName, type.getSingleSQLDataType()));
            }
            for (TableColumnDefinition d : def) {
                columnList.add(new TableColumn(d, null));
            }
        }
        ++nThChildNode;
        if (foundDataIndex == -1) {
            throw new TypeException("didn't match any `choice' candidate");
        }
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", "!!!!! INDEX = ", foundDataIndex);
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", "");
        ((TableColumn)columnList.get(0)).setValue(Integer.toString(foundDataIndex));
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", "");
        return new Pair<TypedInstance, Integer>(new TypedInstance(columnList, this), nThChildNode);
    }

    @Override
    public int convertToXMLElement(Element element, Document doc, StorageManager storage, TransformationContext trans, List<TableColumn> columns, int index, long id) throws TypeException {
        int i = index;
        String value = columns.get(i).getValue();
        int dataElementIndex = value == null ? -1 : Integer.parseInt(value);
        ++i;
        for (int elementIndex = 0; elementIndex < this.getEntries().size(); ++elementIndex) {
            Element child;
            TypeDefinition childType;
            boolean isDataElement;
            AbstractCompositorTypeDefinition.Entry e = this.getEntries().get(elementIndex);
            boolean bl = isDataElement = elementIndex == dataElementIndex;
            if (e.isCompositeEntry()) {
                i = isDataElement ? e.getCompositeEntry().convertToXMLElement(element, doc, storage, trans, columns, i, id) : (i += e.getCompositeEntry().getCompositeSQLDataType(storage, null, null).size());
            }
            XMLSchemaElementDefinition a = e.getAtomEntry();
            TypeName childTypeName = a.getTypeName();
            ElementName childElementName = a.getElementName();
            try {
                childType = storage.getTypeDefinition(childTypeName);
            }
            catch (StorageException se) {
                throw new TypeException(se);
            }
            if (childType.getSingleSQLDataType() != null) {
                if (isDataElement) {
                    child = doc.createElementNS(childElementName.getNamespace(), childElementName.getLocalName());
                    element.appendChild(child);
                    child.appendChild(doc.createTextNode(columns.get(i).getValue()));
                }
                ++i;
                continue;
            }
            if (isDataElement) {
                child = doc.createElementNS(childElementName.getNamespace(), childElementName.getLocalName());
                element.appendChild(child);
                i = childType.convertToXMLElement(child, doc, storage, trans, columns, i, id);
                continue;
            }
            i += childType.getCompositeSQLDataType(storage, null, null).size();
        }
        return i;
    }
}

