/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.geometry.TransformationContext;
import daruma.sql.SQLDataTypeConstant;
import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.ElementInfo;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.AbstractMultiColumnSingleTypeDefinition;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.storage_manager.type_definition.TypeException;
import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;
import daruma.xml.SimpleXPath;
import daruma.xml.util.WhitespaceProceccer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeTypeDefinition
extends AbstractMultiColumnSingleTypeDefinition {
    public static final String ColNameSqlTimeSuffix = "_sql_";
    public static final String ColNameGmlTimeSuffix = "_gml_";

    @Override
    public List<String> parseValue(String value, InstanceParseContext parseContext) throws TypeException {
        String v = WhitespaceProceccer.cutoffEdgeWhitespaces(value);
        ISO8601DateFormat f = new ISO8601DateFormat();
        if (value.equals("now")) {
            v = f.format(parseContext.getVirtualCurrentDate());
        } else {
            try {
                f.parse(v);
            }
            catch (ParseException e) {
                throw new TypeException("\"" + value + "\" is" + " not a valid dateTime value");
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(v);
        ret.add(v);
        return ret;
    }

    @Override
    public List<TableColumnDefinition> getCompositeSQLDataType(StorageManager storage, SimpleXPath path, ElementInfo elementInfo) throws TypeException {
        LogWriter.qwrite("DEBUG", "In ", this.getClass().getName(), ".getCompositeSQLDataType()");
        LogWriter.qwrite("DEBUG", "path = [", path, "]");
        ArrayList<TableColumnDefinition> ret = new ArrayList<TableColumnDefinition>();
        String colNameBody = null;
        if (path == null) {
            colNameBody = ColumnNameFactory.getTopLevelElementColumnName();
            if (elementInfo != null) {
                elementInfo.registerSubElement(new SimpleXPath(), this);
            }
        } else {
            SimpleXPath newPath = new SimpleXPath(path);
            try {
                colNameBody = storage.getShortXPathStringForDB(newPath);
            }
            catch (StorageException ex) {
                throw new TypeException(ex);
            }
            if (elementInfo != null) {
                elementInfo.registerSubElement(newPath, this);
            }
        }
        ret.add(new TableColumnDefinition(colNameBody, SQLDataTypeConstant.TIMESTAMP));
        ret.add(new TableColumnDefinition(ColumnNameFactory.getColumnName(colNameBody, ColNameGmlTimeSuffix), SQLDataTypeConstant.BLOB));
        return ret;
    }

    @Override
    public int convertToXMLElement(Element element, Document doc, StorageManager storage, TransformationContext trans, List<TableColumn> columns, int index, long id) throws TypeException {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ".convertToXMLElement()");
        if (index + 1 >= columns.size()) {
            throw new TypeException("internal error in " + this.getClass().getName() + ": unexpected instantiation");
        }
        String value = columns.get(index + 1).getValue();
        LogWriter.qwrite("DEBUG", this.getClass().getName(), "convertToXMLElement():", "value = ", value);
        if (value != null) {
            Text text = doc.createTextNode(value);
            element.appendChild(text);
        }
        return index + 2;
    }

    @Override
    public boolean shouldSkipColumns(List<TableColumn> columns, int columnIndex) throws TypeException {
        if (columnIndex + 1 >= columns.size()) {
            throw new TypeException("internal error in " + this.getClass().getName() + ": unexpected instantiation");
        }
        String stringValue = columns.get(columnIndex + 1).getValue();
        return stringValue == null;
    }
}

