/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.EulerAngles;
import daruma.geometry.TransformationContext;
import daruma.geometry.TransformationException;
import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;
import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.ElementInfo;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.types.DoubleTypeDefinition;
import daruma.storage_manager.type_definition.types.FloatTypeDefinition;
import daruma.util.EqualChecker;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.SimpleXPath;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import daruma.xml.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EulerAnglesTypeDefinition
extends TypeDefinition {
    private final List<String> ANGLE_COLUMN_NAMES = new ArrayList<String>();
    private final String SRS_NAME_COLUMN_NAME_SUFFIX = "_srs_name_";
    private List<UniversalName> tagNames;
    private UniversalName SRS_NAME_ATTRIBUTE;

    public EulerAnglesTypeDefinition(boolean hasRollPitchYaw) {
        super(true, true);
        this.ANGLE_COLUMN_NAMES.add("alpha");
        this.ANGLE_COLUMN_NAMES.add("beta");
        this.ANGLE_COLUMN_NAMES.add("gamma");
        this.SRS_NAME_COLUMN_NAME_SUFFIX = "_srs_name_";
        this.SRS_NAME_ATTRIBUTE = new UniversalName(null, "srsName");
        this.tagNames = new ArrayList<UniversalName>();
        if (hasRollPitchYaw) {
            this.tagNames.add(new UniversalName(URI.MISP, "roll"));
            this.tagNames.add(new UniversalName(URI.MISP, "pitch"));
            this.tagNames.add(new UniversalName(URI.MISP, "yaw"));
        } else {
            this.tagNames.add(new UniversalName(URI.MISP, "alpha"));
            this.tagNames.add(new UniversalName(URI.MISP, "beta"));
            this.tagNames.add(new UniversalName(URI.MISP, "gamma"));
        }
    }

    @Override
    public SQLDataType getSingleSQLDataType() {
        return null;
    }

    @Override
    public List<TableColumnDefinition> getCompositeSQLDataType(StorageManager storage, SimpleXPath path, ElementInfo elementInfo) throws TypeException {
        ArrayList<TableColumnDefinition> ret = new ArrayList<TableColumnDefinition>();
        String columnNameBase = null;
        if (path == null) {
            columnNameBase = ColumnNameFactory.getTopLevelElementColumnName();
            if (elementInfo != null) {
                elementInfo.registerSubElement(new SimpleXPath(), this);
            }
        } else {
            SimpleXPath newPath = new SimpleXPath(path);
            try {
                columnNameBase = storage.getShortXPathStringForDB(newPath);
            }
            catch (StorageException e) {
                throw new TypeException(e);
            }
            if (elementInfo != null) {
                elementInfo.registerSubElement(newPath, this);
            }
        }
        for (int i = 0; i < this.ANGLE_COLUMN_NAMES.size(); ++i) {
            ret.add(new TableColumnDefinition(ColumnNameFactory.getColumnName(columnNameBase, this.ANGLE_COLUMN_NAMES.get(i)), SQLDataTypeConstant.DOUBLE));
        }
        ret.add(new TableColumnDefinition(ColumnNameFactory.getColumnName(columnNameBase, "_srs_name_"), SQLDataTypeConstant.BLOB));
        return ret;
    }

    @Override
    public Pair<TypedInstance, Integer> createInstance(Element element, ElementName topLevelElement, SimpleXPath path, StorageManager storage, int elementIndex, InstanceParseContext parseContext) throws TypeException {
        List<Element> childElements;
        SimpleXPath p = path;
        if (p != null) {
            p = new SimpleXPath(path, new UniversalName(element));
        }
        if ((childElements = ElementUtil.getChildElements(element)).size() != this.tagNames.size()) {
            throw new TypeException("invalid number of child elements found in " + new UniversalName(element) + ", expected 3 child elements");
        }
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        List<TableColumnDefinition> def = this.getCompositeSQLDataType(storage, p, null);
        FloatTypeDefinition floatDef = new FloatTypeDefinition();
        for (int i = 0; i < this.tagNames.size(); ++i) {
            if (!new UniversalName(childElements.get(i)).equals(this.tagNames.get(i))) {
                throw new TypeException("invalid angle element " + new UniversalName(childElements.get(i)) + " found in " + new UniversalName(element) + ", expected was " + this.tagNames.get(i));
            }
            String valueString = ElementUtil.getChildNodesWholeText(childElements.get(i));
            try {
                valueString = floatDef.parseValue(valueString);
            }
            catch (TypeException e) {
                throw new TypeException("invalid Euler angle: " + e.getMessage());
            }
            columns.add(new TableColumn(def.get(i), valueString));
        }
        String srsName = element.getAttributeNS(this.SRS_NAME_ATTRIBUTE.getNamespace(), this.SRS_NAME_ATTRIBUTE.getLocalName());
        columns.add(new TableColumn(def.get(this.tagNames.size()), srsName));
        return new Pair<TypedInstance, Integer>(new TypedInstance(columns, this), element.getChildNodes().getLength());
    }

    @Override
    public int convertToXMLElement(Element element, Document doc, StorageManager storage, TransformationContext trans, List<TableColumn> columns, int index, long id) throws TypeException {
        assert (this.ANGLE_COLUMN_NAMES.size() == 3);
        int numColumns = this.ANGLE_COLUMN_NAMES.size() + 1;
        if (index + numColumns - 1 >= columns.size()) {
            throw new TypeException("internal error in " + this.getClass().getName() + ": unexpected instantiation");
        }
        String srsName = columns.get(index + this.tagNames.size()).getValue();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < this.ANGLE_COLUMN_NAMES.size(); ++i) {
            String valueString = columns.get(index + i).getValue();
            try {
                values.add(DoubleTypeDefinition.parseDouble(valueString));
                continue;
            }
            catch (TypeException e) {
                throw new TypeException("internal error in " + this.getClass().getName() + ": " + e.getMessage());
            }
        }
        EulerAngles transformedAngles = this.transformEulerAngles(new EulerAngles(srsName, (Double)values.get(0), (Double)values.get(1), (Double)values.get(2)), trans);
        ArrayList<Double> returnValues = new ArrayList<Double>();
        returnValues.add(transformedAngles.getAlpha());
        returnValues.add(transformedAngles.getBeta());
        returnValues.add(transformedAngles.getGamma());
        for (int i = 0; i < returnValues.size(); ++i) {
            UniversalName name = this.tagNames.get(i);
            Element tag = doc.createElementNS(name.getNamespace(), name.getLocalName());
            tag.appendChild(doc.createTextNode(((Double)returnValues.get(i)).toString()));
            element.appendChild(tag);
        }
        if (transformedAngles.getSrsName() != null) {
            element.setAttributeNS(this.SRS_NAME_ATTRIBUTE.getNamespace(), this.SRS_NAME_ATTRIBUTE.getLocalName(), transformedAngles.getSrsName());
        }
        return index + numColumns;
    }

    private EulerAngles transformEulerAngles(EulerAngles angles, TransformationContext trans) {
        switch (trans.getTransformationType()) {
            case Selective: 
            case Conv: {
                CoordinateSystem target = trans.getTargetCoordinateSystem();
                String srsName = angles.getSrsName();
                if (EqualChecker.equals(target.getSrsName(), srsName)) break;
                try {
                    angles = trans.transform(angles);
                }
                catch (TransformationException e) {
                    LogWriter.qwrite("DEBUG", "transform failed: " + e.getMessage());
                }
                break;
            }
        }
        return angles;
    }
}

