/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.storage_manager.StorageAndAuth;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.schema.XMLSchemaSet;
import daruma.storage_manager.type_definition.ElementName;
import daruma.wfs.ResponseInfo;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.xml.Lexicon;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import daruma.xml.XMLTag;
import daruma.xml.handler.MispDefaultHandler;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLFormatConverter;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DescribeFeatureTypeHandler
extends MispDefaultHandler {
    private StorageManager storage;
    private List<UniversalName> typeList;
    private boolean readingTypeName;
    private StringBuilder typeNameBuffer;

    public DescribeFeatureTypeHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, StorageAndAuth storage) {
        super(out, parser, isTopLevelHandler);
        this.storage = storage.getStorage();
        this.typeList = new ArrayList<UniversalName>();
        this.readingTypeName = false;
        this.typeNameBuffer = null;
    }

    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        assert (super.getCurrentLevel() == 1 || super.getCurrentLevel() == 2);
        XMLTag t = new XMLTag(uri, localName);
        SAXParseException mispNamespaceException = new SAXParseException(t.getLocalName() + " tag " + "should be in namespace " + URI.MISP, super.getLocator());
        if (super.getCurrentLevel() == 1) {
            if (!t.getURI().equals(URI.MISP)) {
                this.throwError(mispNamespaceException);
            }
            if (!t.getLocalName().equals("DescribeFeatureType")) {
                this.throwError(new SAXParseException("unknown tag " + t.getLocalName() + ".", super.getLocator()));
            }
            return;
        }
        if (super.getCurrentLevel() == 2) {
            if (!t.getURI().equals(URI.MISP)) {
                this.throwError(mispNamespaceException);
            }
            if (!t.getLocalName().equals("TypeName")) {
                this.throwError(new SAXParseException("unexpected tag \"" + t.getLocalName() + "\" found, " + "TypeName tag expected.", super.getLocator()));
            }
            this.readingTypeName = true;
            this.typeNameBuffer = new StringBuilder();
        }
    }

    public void xCharacters(char[] str, int offset, int length) throws SAXException {
        if (this.readingTypeName) {
            this.typeNameBuffer.append(str, offset, length);
        }
    }

    public void xEndElement(String uri, String localName, String qName) throws SAXException {
        if (this.readingTypeName) {
            try {
                this.typeList.add(super.convertQNameStringToUniversalName(this.typeNameBuffer.toString()));
            }
            catch (SAXException e) {
                this.throwError(new SAXParseException("type definition of \"" + this.typeNameBuffer.toString() + "\" not found" + ": " + e.getMessage(), super.getLocator()));
            }
            this.readingTypeName = false;
            this.typeNameBuffer = null;
        }
    }

    public void xEndDocument() throws SAXException {
        XMLSchemaSet schemaSet = new XMLSchemaSet();
        for (UniversalName typeName : this.typeList) {
            try {
                this.storage.getSchemasOfElement(new ElementName(typeName), schemaSet);
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException("type definition of " + typeName + " not found", super.getLocator()));
            }
        }
        this.constructResponseInfo(schemaSet);
    }

    private void constructResponseInfo(XMLSchemaSet schemaSet) throws SAXException {
        ResponseInfo responseInfo = this.getResponse();
        Document doc = responseInfo.document;
        Element response = ElementUtil.genElementSimple(Lexicon.MispDescribeFeatureTypeResponse, null, doc, responseInfo.leaf, true);
        responseInfo.setResponseToLeaf(response);
        try {
            Date ctime;
            Date btime;
            Date etime = btime = (ctime = this.storage.getCurrentTime());
            responseInfo.addResponseStatusToLeaf(this.storage.getMostRecentTransactionURI(), btime, etime);
        }
        catch (StorageException ex) {
            ex.printStackTrace();
            throw new SAXException(ex);
        }
        for (XMLSchemaSet.Entry entry : schemaSet.getList()) {
            response.appendChild(doc.createComment(" ========== schema ID=" + entry.getID() + " / " + "target NS=" + entry.getTargetNameSpace() + " ========== "));
            try {
                XMLFormatConverter.readNode(new StringReader(entry.getString()), (Node)response);
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                throw new SAXException(ex);
            }
        }
    }

    public void throwError(SAXParseException e) throws SAXException {
        try {
            XMLFormatConverter.print(new SOAPFaultDocumentBuilder(e).newDocument(), this.getOutputStream());
        }
        catch (ParserConfigurationException pe) {
            throw new SAXException(pe);
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
        throw e;
    }
}

