/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.storage_manager.StorageAndAuth;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.wfs.ResponseInfo;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.wfs.TransactionDeleteHandler;
import daruma.wfs.TransactionInsertHandler;
import daruma.wfs.TransactionResultInfo;
import daruma.wfs.TransactionUpdateHandler;
import daruma.xml.Lexicon;
import daruma.xml.NameSpace;
import daruma.xml.SAXExceptionObserver;
import daruma.xml.handler.MispDefaultHandler;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLFormatConverter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TransactionHandler
extends MispDefaultHandler
implements SAXExceptionObserver {
    private StorageAndAuth storage;
    private InstanceParseContext parseContext;
    private Date startTime;
    private Date endTime;
    private boolean errorOccured;
    private List<Exception> errors;
    private TransactionResultInfo resultInfo;

    public TransactionHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, StorageAndAuth storage, InstanceParseContext parseContext) {
        super(out, parser, isTopLevelHandler);
        this.storage = storage;
        this.parseContext = parseContext;
        this.startTime = null;
        this.endTime = null;
        this.errorOccured = false;
        this.errors = new ArrayList<Exception>();
        this.resultInfo = new TransactionResultInfo();
    }

    public void xStartDocument() throws SAXException {
        try {
            this.setTransactionURI();
            this.setTransactionSN(this.storage.getStorage().registerTransactionURI(this.getTransactionURI()));
        }
        catch (StorageException e) {
            throw new SAXException(e);
        }
    }

    public void notifyError(SAXParseException e) throws SAXException {
        this.errorOccured = true;
        this.errors.add(e);
        this.finishAndResponse();
    }

    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        assert (super.getCurrentLevel() == 1 || super.getCurrentLevel() == 2);
        if (super.getCurrentLevel() == 1) {
            Lexicon.MispTransaction.matchesOrSaxException(uri, null, localName, super.getLocator(), null);
            try {
                this.startTime = this.storage.getStorage().getCurrentTime();
            }
            catch (StorageException ex) {
                throw new SAXParseException(ex.getMessage(), super.getLocator(), ex);
            }
            return;
        }
        if (Lexicon.MispInsert.matches(uri, localName)) {
            super.setContentHandlerDelegator(new TransactionInsertHandler(super.getOutputStream(), super.getParser(), false, this.storage, this.parseContext, this, this.resultInfo), uri, localName, qName, attrs);
            return;
        }
        if (Lexicon.MispDelete.matches(uri, localName)) {
            super.setContentHandlerDelegator(new TransactionDeleteHandler(super.getOutputStream(), super.getParser(), false, this.storage, this.parseContext, this, this.resultInfo), uri, localName, qName, attrs);
            return;
        }
        if (!Lexicon.MispUpdate.matches(uri, localName)) {
            throw new SAXParseException("unknown top level tag <" + NameSpace.genUName(uri, localName) + ">.", super.getLocator());
        }
        super.setContentHandlerDelegator(new TransactionUpdateHandler(super.getOutputStream(), super.getParser(), false, this.storage, this.parseContext, this, this.resultInfo), uri, localName, qName, attrs);
    }

    public void xEndDocument() throws SAXException {
        this.finishAndResponse();
    }

    public void finishAndResponse() throws SAXException {
        try {
            this.endTime = this.storage.getStorage().getCurrentTime();
        }
        catch (StorageException e) {
            throw new SAXException(e);
        }
        this.constructResponseInfo();
    }

    private void constructResponseInfo() {
        ResponseInfo responseInfo = this.getResponse();
        Element response = ElementUtil.genElementSimple(Lexicon.MispTransactionResponse, null, responseInfo.document, responseInfo.leaf, true);
        responseInfo.setResponseToLeaf(response);
        responseInfo.addResponseStatusToLeaf(this.getTransactionURI(), this.startTime, this.endTime);
        Element transResult = ElementUtil.genElementSimple(Lexicon.MispTransactionResult, null, responseInfo.document, response, true);
        ElementUtil.genElementSimple(Lexicon.MispTransactionID, this.getTransactionURI(), responseInfo.document, transResult, true);
        ElementUtil.genElementSimple(Lexicon.MispStatus, this.errorOccured ? Lexicon.MispStatus_Failure.localname : Lexicon.MispStatus_Success.localname, responseInfo.document, transResult, true);
        if (this.resultInfo.countInsert >= 0L) {
            ElementUtil.genElementSimple(Lexicon.MispInsertCount, Long.toString(this.resultInfo.countInsert), responseInfo.document, transResult, true);
        }
        if (this.resultInfo.countUpdate >= 0L) {
            ElementUtil.genElementSimple(Lexicon.MispUpdateCount, Long.toString(this.resultInfo.countUpdate), responseInfo.document, transResult, true);
        }
        if (this.resultInfo.countDelete >= 0L) {
            ElementUtil.genElementSimple(Lexicon.MispDeleteCount, Long.toString(this.resultInfo.countDelete), responseInfo.document, transResult, true);
        }
        if (!this.errors.isEmpty()) {
            Element error = ElementUtil.genElementSimple(Lexicon.MispError, null, responseInfo.document, transResult, true);
            for (Exception ex : this.errors) {
                ElementUtil.genElementSimple(Lexicon.MispErrorMessage, ex.getMessage(), responseInfo.document, error, true);
            }
        }
    }

    public void xFatalError(SAXParseException exception) throws SAXException {
        this.printError(exception, "fatal error");
    }

    public void xError(SAXParseException exception) throws SAXException {
        this.printError(exception, "error");
    }

    public void xWarning(SAXParseException exception) throws SAXException {
        this.printError(exception, "warning");
    }

    protected void printError(SAXParseException e, String type) throws SAXException {
        try {
            XMLFormatConverter.print(new SOAPFaultDocumentBuilder(e).newDocument(), this.getOutputStream());
        }
        catch (ParserConfigurationException pe) {
            throw new SAXException(pe);
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }
}

