/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.storage_manager.BulkInsertBuffer;
import daruma.storage_manager.StorageAndAuth;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.type_definition.InstanceParseContext;
import daruma.wfs.TransactionHandler;
import daruma.wfs.TransactionResultInfo;
import daruma.wfs.transaction.InsertAnElementHandler;
import daruma.xml.Lexicon;
import daruma.xml.handler.MispDefaultHandler;
import java.io.OutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TransactionInsertHandler
extends MispDefaultHandler {
    private StorageAndAuth storage;
    private InstanceParseContext parseContext;
    private TransactionHandler errorReceiver;
    private InsertAnElementHandler insertHandler;
    private BulkInsertBuffer bulkInsertBuffer;
    private TransactionResultInfo resultInfo;

    public TransactionInsertHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, StorageAndAuth storage, InstanceParseContext parseContext, TransactionHandler errorReceiver, TransactionResultInfo resultInfo) {
        super(out, parser, isTopLevelHandler);
        this.storage = storage;
        this.parseContext = parseContext;
        this.errorReceiver = errorReceiver;
        this.insertHandler = null;
        this.bulkInsertBuffer = new BulkInsertBuffer();
        this.resultInfo = resultInfo;
        if (this.resultInfo.countInsert < 0L) {
            this.resultInfo.countInsert = 0L;
        }
    }

    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        assert (super.getCurrentLevel() == 1 || super.getCurrentLevel() == 2);
        if (super.getCurrentLevel() == 1) {
            Lexicon.MispInsert.matchesOrSaxException(uri, null, localName, super.getLocator(), "in Transaction");
            return;
        }
        if (this.insertHandler == null) {
            this.insertHandler = new InsertAnElementHandler(super.getOutputStream(), super.getParser(), false, this.storage, this.parseContext, this.bulkInsertBuffer, this.errorReceiver, this.resultInfo);
        } else {
            this.insertHandler.reset();
        }
        super.setContentHandlerDelegator(this.insertHandler, uri, localName, qName, attrs);
    }

    public void xEndElement(String uri, String localName, String qName) throws SAXException {
        try {
            long nElements = this.bulkInsertBuffer.size();
            this.storage.getStorage().bulkInsertElement(this.bulkInsertBuffer, super.getTransactionSN(), this.storage.getPermission(), this.storage.getAuth());
            this.resultInfo.countInsert += nElements;
        }
        catch (StorageException e) {
            this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
        }
    }

    private void throwError(SAXParseException e) throws SAXException {
        this.errorReceiver.notifyError(e);
        throw e;
    }
}

