/*
 * Decompiled with CFR 0.152.
 */
package darumaDump;

import daruma.storage_manager.type_definition.ElementName;
import daruma.util.FatalException;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import mispClient.DirectMispClient;
import mispClient.HttpMispClient;
import mispClient.MispClient;
import mispClient.MispCommandException;
import mispClient.commands.DescribeFeatureTypeMispCommand;
import mispClient.commands.GetCapabilitiesMispCommand;
import mispClient.commands.GetFeatureDataOnlyMispCommand;
import util.FilePathConverter;
import util.InputStreamStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DarumaDump {
    private static final String PROGRAM_NAME = "DarumaDump";
    private static final String DEFAULT_MISP_HOST = "localhost";
    private static final int DEFAULT_MISP_PORT = 5050;
    private static final boolean DEFAULT_HTTP = false;
    private static final String DEFAULT_HTTP_ADDRESS_LOCAL_PART = "daruma";
    private static final String DEFAULT_SCHEMA_DUMP_FILE = "schema.xml";
    private String host;
    private int port;
    private boolean http;
    private String httpAddressLocalPart;
    private OutputStream dataOutputStream;
    private OutputStream schemaOutputStream;
    private String featureDumpDir;
    private UniversalName specifiedFeatureName;
    private String filterFilePath;
    private boolean debugFlag;

    public DarumaDump(String host, int port, boolean http, String httpAddressLocalPart, OutputStream dataOutputStream, OutputStream schemaOutputStream, String featureDumpDir, UniversalName specifiedFeatureName, String filterFilePath, boolean debugFlag) {
        this.host = host;
        this.port = port;
        this.http = http;
        this.httpAddressLocalPart = httpAddressLocalPart;
        this.dataOutputStream = dataOutputStream;
        this.schemaOutputStream = schemaOutputStream;
        this.featureDumpDir = featureDumpDir;
        this.specifiedFeatureName = specifiedFeatureName;
        this.filterFilePath = filterFilePath;
        this.debugFlag = debugFlag;
    }

    public void run() throws FatalException {
        try {
            List<ElementName> features;
            MispClient client = this.http ? new HttpMispClient(this.host, this.port, this.httpAddressLocalPart) : new DirectMispClient(this.host, this.port);
            String filter = null;
            if (this.filterFilePath != null) {
                filter = new InputStreamStringBuilder(new FileInputStream(this.filterFilePath)).toString();
            }
            GetCapabilitiesMispCommand getCapabilities = new GetCapabilitiesMispCommand();
            client.issue(getCapabilities);
            if (this.specifiedFeatureName != null) {
                features = new ArrayList<ElementName>();
                features.add(new ElementName(this.specifiedFeatureName));
            } else {
                features = getCapabilities.getFeatureList();
            }
            if (this.debugFlag) {
                System.err.println("=== feature list ===");
                for (ElementName f : features) {
                    System.err.println(f);
                }
                System.err.println("====================");
            }
            if (this.schemaOutputStream != null) {
                DarumaDump.outputRegisterFeatureType(client, this.schemaOutputStream, features);
            }
            if (this.featureDumpDir == null) {
                DarumaDump.outputAllFeature(client, this.dataOutputStream, features, filter);
            } else {
                File dir = new File(this.featureDumpDir);
                if (!dir.exists()) {
                    if (!dir.mkdirs()) {
                        throw new FatalException("Can't create directory [" + this.featureDumpDir + "].");
                    }
                } else if (!dir.isDirectory()) {
                    throw new FatalException("[" + this.featureDumpDir + "]" + " is not a directory.");
                }
                for (ElementName f : features) {
                    System.err.print(f + " ...");
                    FileOutputStream file = new FileOutputStream(new File(this.featureDumpDir, FilePathConverter.escapePathString(f.toString() + ".misp")));
                    DarumaDump.outputFeature(client, file, f, filter);
                    ((OutputStream)file).close();
                    System.err.println(" done");
                }
            }
        }
        catch (MispCommandException e) {
            System.err.println("command error: " + e.getMessage());
            System.exit(1);
        }
        catch (ConnectException e) {
            System.err.println("connection error: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("IO error: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void outputFeature(MispClient client, OutputStream dataOutputStream, ElementName feature, String filter) throws MispCommandException, ConnectException, IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(dataOutputStream, "UTF-8")));
        out.println("<misp:Transaction xmlns:misp=\"" + URI.MISP + "\">");
        out.println("  <misp:Insert>");
        out.flush();
        client.issue(new GetFeatureDataOnlyMispCommand(feature, filter, dataOutputStream, "UTF-8"));
        out.println("  </misp:Insert>");
        out.println("</misp:Transaction>");
        out.flush();
        out.close();
    }

    private static void outputAllFeature(MispClient client, OutputStream dataOutputStream, List<ElementName> features, String filter) throws MispCommandException, ConnectException, IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(dataOutputStream, "UTF-8")));
        out.println("<misp:Transaction xmlns:misp=\"" + URI.MISP + "\">");
        out.println("  <misp:Insert>");
        out.flush();
        for (ElementName f : features) {
            client.issue(new GetFeatureDataOnlyMispCommand(f, filter, dataOutputStream, "UTF-8"));
        }
        out.println("  </misp:Insert>");
        out.println("</misp:Transaction>");
        out.flush();
        out.close();
    }

    private static void outputRegisterFeatureType(MispClient client, OutputStream dataOutputStream, List<ElementName> features) throws MispCommandException, ConnectException, IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(dataOutputStream, "UTF-8")));
        out.println("<misp:RegisterFeatureType xmlns:misp=\"" + URI.MISP + "\">");
        out.println();
        out.flush();
        DescribeFeatureTypeMispCommand describeFeatureType = new DescribeFeatureTypeMispCommand(features, dataOutputStream, "UTF-8");
        client.issue(describeFeatureType);
        out.println();
        out.println("</misp:RegisterFeatureType>");
        out.flush();
    }

    public static void main(String[] args) {
        DarumaDumpOptionAnalyzer opt = new DarumaDumpOptionAnalyzer(args, PROGRAM_NAME, DEFAULT_MISP_HOST, 5050, false, DEFAULT_HTTP_ADDRESS_LOCAL_PART, DEFAULT_SCHEMA_DUMP_FILE);
        if (!opt.analyze()) {
            opt.printHelp(System.err);
            System.exit(1);
        } else if (opt.getHelp()) {
            opt.printHelp(System.out);
            System.exit(0);
        }
        FileOutputStream schemaOutputStream = null;
        try {
            schemaOutputStream = new FileOutputStream(opt.getSchemaDumpFile());
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        DarumaDump darumaDump = new DarumaDump(opt.getHost(), opt.getPort(), opt.getHttp(), opt.getHttpAddressLocalPart(), System.out, schemaOutputStream, opt.getFeatureDumpDir(), opt.getFeatureName(), opt.getFilterFilePath(), opt.getDebug());
        try {
            darumaDump.run();
        }
        catch (FatalException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            if (schemaOutputStream != null) {
                schemaOutputStream.flush();
                ((OutputStream)schemaOutputStream).close();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public static class DarumaDumpOptionAnalyzer {
        private String[] args;
        private String programName;
        private String host;
        private int port;
        private boolean http;
        private String httpAddressLocalPart;
        private UniversalName featureName = null;
        private String filterFilePath = null;
        private boolean helpFlag = false;
        private boolean debugFlag = false;
        private String schemaDumpFile = null;
        private String featureDumpDir = null;
        private boolean defaultHttp = false;
        private String defaultHttpAddressLocalPart = null;
        private String defaultSchemaDumpFile = null;

        public DarumaDumpOptionAnalyzer(String[] args, String programName, String defaultMispHost, int defaultMispPort, boolean defaultHttp, String defaultHttpAddressLocalPart, String defaultSchemaDumpFile) {
            this.args = (String[])args.clone();
            this.programName = programName;
            this.host = defaultMispHost;
            this.port = defaultMispPort;
            this.http = defaultHttp;
            this.httpAddressLocalPart = defaultHttpAddressLocalPart;
            this.featureName = null;
            this.filterFilePath = null;
            this.schemaDumpFile = defaultSchemaDumpFile;
            this.featureDumpDir = null;
            this.defaultHttp = defaultHttp;
            this.defaultHttpAddressLocalPart = defaultHttpAddressLocalPart;
            this.defaultSchemaDumpFile = defaultSchemaDumpFile;
        }

        public boolean analyze() {
            for (int index = 0; index < this.args.length; ++index) {
                String arg = this.args[index];
                int numArgs = this.args.length - index - 1;
                if (arg.equals("--help")) {
                    this.helpFlag = true;
                    continue;
                }
                if (arg.equals("--debug")) {
                    this.debugFlag = true;
                    continue;
                }
                if (arg.equals("--host") || arg.equals("-h")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.host = this.args[++index];
                    continue;
                }
                if (arg.equals("--port") || arg.equals("-p")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    ++index;
                    try {
                        this.port = Integer.parseInt(this.args[index]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("invalid port number: " + this.args[index]);
                        return false;
                    }
                }
                if (arg.equals("--http") || arg.equals("-H")) {
                    this.http = true;
                    continue;
                }
                if (arg.equals("--http-address-local-part") || arg.equals("-L")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.httpAddressLocalPart = this.args[++index];
                    continue;
                }
                if (arg.equals("--schema-dump-file")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.schemaDumpFile = this.args[++index];
                    continue;
                }
                if (arg.equals("--feature-dump-dir")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.featureDumpDir = this.args[++index];
                    continue;
                }
                if (arg.equals("--feature")) {
                    if (numArgs < 2) {
                        return false;
                    }
                    this.featureName = new UniversalName(this.args[index + 1], this.args[index + 2]);
                    index += 2;
                    continue;
                }
                if (arg.equals("--filter-file")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.filterFilePath = this.args[index + 1];
                    ++index;
                    continue;
                }
                System.err.println("invalid option: " + arg);
                return false;
            }
            return true;
        }

        public void printHelp(OutputStream out) {
            String mes = "";
            mes = mes + "Usage: " + this.programName + " [--schema-dump-file FILE]" + " [options] > DUMP_FILE" + "\n";
            mes = mes + "Possible options are:\n";
            mes = mes + "      --help\n";
            mes = mes + "      --debug\n";
            mes = mes + "  -h, --host HOST\n";
            mes = mes + "  -p, --port PORT\n";
            mes = mes + "  -H, --http (default: " + this.defaultHttp + ")\n";
            mes = mes + "  -L, --http-address-local-part PATH (default: " + this.defaultHttpAddressLocalPart + ")\n";
            mes = mes + "      --schema-dump-file FILE (default: " + this.defaultSchemaDumpFile + ")" + "\n";
            mes = mes + "      --feature-dump-dir DIR (default: none, standard output)\n";
            mes = mes + "      --feature NAMESPACE LOCAL_NAME (default: all features)\n";
            mes = mes + "      --filter-file FILE\n";
            PrintStream p = new PrintStream(out);
            p.print(mes);
        }

        public boolean getHelp() {
            return this.helpFlag;
        }

        public boolean getDebug() {
            return this.debugFlag;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean getHttp() {
            return this.http;
        }

        public String getHttpAddressLocalPart() {
            return this.httpAddressLocalPart;
        }

        public UniversalName getFeatureName() {
            return this.featureName;
        }

        public String getFilterFilePath() {
            return this.filterFilePath;
        }

        public String getSchemaDumpFile() {
            return this.schemaDumpFile;
        }

        public String getFeatureDumpDir() {
            return this.featureDumpDir;
        }
    }
}

