package mispClient;

import mispClient.MispClient;

import java.net.Socket;
import java.net.ConnectException;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;


public class DirectMispClient extends MispClient
{
	private	static	final	int	BUFFER_SIZE = 8192;

	private	String	host;
	private	int	port;

	public	DirectMispClient( String  host ,  int  port )
	{
		this.host = host;
		this.port = port;
	}

	public	InputStream	getResultStream( InputStream  in )
					throws ConnectException , IOException
	{
		Socket	socket = new Socket( this.host , port );

		OutputStream	out = socket.getOutputStream();

		byte[]	buf = new byte[BUFFER_SIZE];
		int	nRead = 0;

		while( (nRead = in.read( buf )) > 0 )
		{
			out.write( buf , 0 , nRead );
		}

		in.close();

		socket.shutdownOutput();

		return( socket.getInputStream() );
	}
}
