package mispClient.commands;

import mispClient.MispCommand;
import mispClient.MispCommandException;
import xmlUtil.XMLUtil;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.UniversalName;
import daruma.xml.URI;
import daruma.xml.QName;
import daruma.xml.util.XMLParseErrorException;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.ArrayList;


public class GetCapabilitiesMispCommand extends MispCommand
{
	private	static final String	GET_CAPABILITIES_ELEMENT_NAME
							= "GetCapabilities";
	private	static final String	MISP_PREFIX = "misp";


	private	List<ElementName>	features;

	public	GetCapabilitiesMispCommand()
	{
		this.features = new ArrayList<ElementName>();
	}


	@Override
	public	InputStream	getInputStream()
	{
		StringBuilder	buf = new StringBuilder();

		buf.append( "<" + MISP_PREFIX + ":"
			    + GET_CAPABILITIES_ELEMENT_NAME
			    + " xmlns:" + MISP_PREFIX + "=\""
			    + URI.MISP + "\"/>" );

		return( new ByteArrayInputStream
			( buf.toString().getBytes() ) );
	}


	@Override
	public	void	processResponse( InputStream  in )
					   throws MispCommandException
	{
		List<UniversalName>	names;

		try
		{
			names = XMLUtil.getUniversalNamesFromXPathQName
					( "//*[local-name()='Name'"
					  + " and namespace-uri()='"
					  + URI.MISP + "']" ,
					  in );
		}
		catch( XMLParseErrorException  e )
		{
			throw new MispCommandException( e );
		}
		catch( XPathExpressionException  e )
		{
			// internal error, XPath expression was invalid
			throw new MispCommandException( e );
		}


		for ( UniversalName  n  :  names )
		{
			this.features.add( new ElementName( n ) );
		}
	}


	public	List<ElementName>	getFeatureList()
	{
		return( this.features );
	}
}
