package mispClient.commands;

import mispClient.MispCommand;
import mispClient.MispCommandException;
import util.StreamPipe;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.URI;
import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.util.XMLFormatConverter;
import daruma.util.CharacerCodeConstant;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;


public class GetFeatureMispCommand extends MispCommand
{
	private	static final String	GET_FEATURE_ELEMENT_NAME
						    = "GetFeature";
	private	static final String	QUERY_ELEMENT_NAME
						    = "Query";
	private	static final String	FILTER_ELEMENT_NAME
						    = "Filter";
	private	static final String	TRUE_ELEMENT_NAME
						    = "True";
	private	static final String	MISP_PREFIX = "misp";


	private	final ElementName	featureName;
	private	final String		filter;
	private	final OutputStream	out;

	public	GetFeatureMispCommand( ElementName  featureName ,
				       String  filter ,
				       OutputStream  out )
	{
		this.featureName = featureName;
		this.filter = filter;
		this.out = out;
	}


	@Override
	public	InputStream	getInputStream()
					   throws MispCommandException
	{
		/*
		Document	doc;

		try
		{
			doc = DOMDocumentFactory.create();
		}
		catch( ParserConfigurationException  e )
		{
			throw new MispCommandException( e );
		}

		String	localName = featureName.getLocalName();

		Element	getFeatureElement = doc.createElementNS
						( URI.MISP ,
						  MISP_PREFIX + ":"
						  + GET_FEATURE_ELEMENT_NAME );

		getFeatureElement.setAttributeNS
			( URI.XMLNS , "xmlns" ,
				    this.featureName.getNamespace() );

		doc.appendChild( getFeatureElement );


		Element	queryElement = doc.createElementNS
					   ( URI.MISP ,
					     MISP_PREFIX + ":"
					     + QUERY_ELEMENT_NAME );

		getFeatureElement.appendChild( queryElement );

		queryElement.setAttribute( "typeName" ,
					   featureName.getLocalName() );

		Element	filterElement = doc.createElementNS
					    ( URI.MISP ,
					      MISP_PREFIX + ":"
					      + FILTER_ELEMENT_NAME );

		queryElement.appendChild( filterElement );

		Element	trueElement = doc.createElementNS
					  ( URI.MISP ,
					    MISP_PREFIX + ":"
					    + TRUE_ELEMENT_NAME );

		filterElement.appendChild( trueElement );


		ByteArrayOutputStream	buf = new ByteArrayOutputStream();

		try
		{
			XMLFormatConverter.print( doc , buf );
		}
		catch( TransformerException  e )
		{
			throw new MispCommandException( e );
		}

		return( new ByteArrayInputStream( buf.toByteArray() ) );
		*/


		StringBuilder	buf = new StringBuilder();

		buf.append( "<" + MISP_PREFIX + ":"
			    + GET_FEATURE_ELEMENT_NAME
			    + " xmlns:" + MISP_PREFIX + "=\""
			    + URI.MISP + "\""
			    + " xmlns=\"" + featureName.getNamespace()
			    + "\">\n" );

		String	localName = featureName.getLocalName();

		buf.append( "  <" + MISP_PREFIX + ":" + QUERY_ELEMENT_NAME
			    + " typeName=\"" + localName + "\">\n" );

		if ( this.filter != null )
		{
		    buf.append( this.filter );
		}
		else
		{
		    buf.append( "    <" + MISP_PREFIX + ":" + FILTER_ELEMENT_NAME
				+ ">\n" );
		    buf.append( "      <" + MISP_PREFIX + ":" + TRUE_ELEMENT_NAME
				+ "/>\n" );
		    buf.append( "    </" + MISP_PREFIX + ":" + FILTER_ELEMENT_NAME
				+ ">\n" );
		}

		buf.append( "  </" + MISP_PREFIX + ":" + QUERY_ELEMENT_NAME
			    + ">\n" );

		buf.append( "</" + MISP_PREFIX + ":"
			    + GET_FEATURE_ELEMENT_NAME + ">\n" );

		try
		{
			return( new ByteArrayInputStream
				( buf.toString().getBytes
				  ( CharacerCodeConstant.JAVA_UTF8 ) ) );
		}
		catch( UnsupportedEncodingException  e )
		{
			throw new MispCommandException( e );
		}
		catch( IOException  e )
		{
			throw new MispCommandException( e );
		}
	}


	@Override
	public	void	processResponse( InputStream  in )
					   throws MispCommandException
	{
		try
		{
			StreamPipe.connect( in , this.out );
		}
		catch( IOException  e )
		{
			throw new MispCommandException( e );
		}
	}
}
