package daruma.storage_manager;

import daruma.storage_manager.StorageManager;

import daruma.storage_manager.StorageManager;
import daruma.auth.PermissionManager;
import daruma.auth.AccountManager;
import daruma.auth.AuthenticationInfo;

public class StorageAndAuth
{
    private StorageManager storage;
    private PermissionManager permission;
    private AccountManager accountManager;
    private AuthenticationInfo auth;

    public StorageAndAuth( StorageManager storage,
			   PermissionManager permissionManager,
			   AccountManager accountManager,
			   AuthenticationInfo authenticationInfo )
    {
	this.storage = storage;
	this.permission = permissionManager;
	this.accountManager = accountManager;
	this.auth = authenticationInfo;
    }

    public StorageManager getStorage()
    {
	return this.storage;
    }

    public PermissionManager getPermission()
    {
	return this.permission;
    }

    public AccountManager getAccountManager()
    {
	return this.accountManager;
    }


    public AuthenticationInfo getAuth()
    {
	return this.auth;
    }

    public void setAuth( AuthenticationInfo auth )
    {
	this.auth = auth;
    }
}
