package daruma.storage_manager.type_definition.types;

import daruma.storage_manager.type_definition.AbstractSingleTypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.sql.SQLDataType;

import daruma.xml.util.WhitespaceProceccer;


public class IntegerTypeDefinition extends AbstractSingleTypeDefinition
{
	private	Long	minValue = null;
	private	Long	maxValue = null;

	public	IntegerTypeDefinition()
	{
		super();
	}

	public	void	setMinInclusiveValue( long minValue )
	{
		this.minValue = new Long( minValue );
	}

	public	void	setMaxInclusiveValue( long maxValue )
	{
		this.maxValue = new Long( maxValue );
	}

	public	IntegerTypeDefinition	deepCopy()
	{
		IntegerTypeDefinition ret = new IntegerTypeDefinition();

		if ( this.minValue != null )
		{
		    ret.setMinInclusiveValue( this.minValue );
		}

		if ( this.maxValue != null )
		{
		    ret.setMaxInclusiveValue( this.maxValue );
		}

		return ret;
	}

	@Override
	public	SQLDataType	getSingleSQLDataType()
	{
		/*
		return( new SQLDataType( "int" , Integer.class ) );
		*/
		return( new SQLDataType( "bigint" , Long.class ) );
	}

	@Override
	public	String	parseValue( String  value ) throws TypeException
	{
		String	v = WhitespaceProceccer.cutoffEdgeWhitespaces( value );
		long longValue;

		try
		{
			longValue = Long.parseLong( v );
		}
		catch( NumberFormatException  e )
		{
			throw new TypeException
			  ( "\"" + value + "\" is not a valid integer value" );
		}

		if ( this.minValue != null
		     && longValue < this.minValue )
		{
			throw new TypeException
			  ( "\"" + longValue + "\" is too small value" );
		}
		else if ( this.maxValue != null
			  && longValue > this.maxValue )
		{
			throw new TypeException
			  ( "\"" + longValue + "\" is too big value" );
		}

		return( v );
	}
}
