package daruma.xml.handler.test.sample;

import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.io.OutputStream;
import java.io.PrintWriter;

public class SampleHandler extends DefaultHandler
{
	private	PrintWriter	out;

	public	SampleHandler( OutputStream  out )
	{
		this.out = new PrintWriter( out );
	}

	public	void	startDocument() throws SAXException
	{
		this.out.println( "startDocument" );
		this.out.flush();
	}

	public	void	endDocument() throws SAXException
	{
		this.out.println( "endDocument" );
		this.out.flush();
	}

	public	void	startElement( String uri ,
				      String localName ,
				      String qName ,
				      Attributes  attrs ) throws SAXException
	{
		this.out.println( "startElement: uri = [" + uri + "], "
				    + "localName = [" + localName + "], "
				    + "qName = [" + qName + "]" );
		this.out.flush();
	}

	public	void	endElement( String uri ,
				    String localName ,
				    String qName ) throws SAXException
	{
		this.out.println( "endElement  : uri = [" + uri + "], "
				    + "localName = [" + localName + "], "
				    + "qName = [" + qName + "]" );
		this.out.flush();
	}

	public	void	characters( char[]  str ,  int  offset ,  int  length )
							   throws SAXException
	{
		this.out.println( "characters: "
				    + "str = ["
				    + new String( str, offset , length )
				    + "]" );
		this.out.flush();
	}

	public	void	startPrefixMapping( String  prefix ,  String  uri )
							throws SAXException
	{
		this.out.println( "startPrefixMapping: "
				    + "prefix = [" + prefix + "], "
				    + "uri = " + uri );
		this.out.flush();
	}

	public	void	endPrefixMapping( String  prefix ) throws SAXException
	{
		this.out.println( "endPrefixMapping  : "
				    + "prefix = [" + prefix + "]" );
		this.out.flush();
	}
}
