using System;
using System.Data;
using System.Data.OracleClient;
using System.Data.SqlClient;
using System.Data.Odbc;
using System.IO;

namespace DBConnect
{
	public class Db
	{

		//OraclẽRlNV
		IDbConnection conn = null;

		//DBڑ{郁\bh(Oracle)
		public void ConnectOracle(string user,string pass,string service)
		{
			Console.WriteLine("DBڑ(Oracle)");
			conn = new OracleConnection ("User Id=" + user +";Password=" + pass + ";Data Source=" + service);
			conn.Open();
		}
		
		//DBڑ{郁\bh(SQLServer)
		public void ConnectSqlServer(string user,string pass,string server,string database)
		{
			Console.WriteLine("DBڑ(SQLServer)");
			conn = new SqlConnection ("server=" + server + ";uid=" + user +";pwd=" + pass + ";database=" + database);
			conn.Open();
		}

		//DBڑ{郁\bh(ODBC)
		public void ConnectOdbc(string user,string pass,string dsn)
		{
			Console.WriteLine("DBڑ(ODBC)");
			//DataSourceڑ
			conn = new OdbcConnection ("dsn=" + dsn + ";UID=" + user +";PWD=" + pass);
			conn.Open();
		}

		//DBڑ{郁\bh(Ms-Access JET)
		public void ConnectAccess(string mdbpath)
		{
			Console.WriteLine("DBڑ(Access)");
			//JETڑ
			conn = new OdbcConnection ("Driver={Microsoft Access Driver (*.mdb)};DBQ=" + mdbpath + ";UID=;PWD=;");
			conn.Open();
		}

//
//		cn= new OdbcConnection("Driver={SQL Server};Server=mySQLServer;UID=sa;
//		PWD=myPassword;Database=Northwind;");
//		myConnection = "DRIVER={SQL Server};SERVER=MyServer;Trusted_connection=yes;DATABASE=northwind;";
//		cn= new OdbcConnection("Driver={Microsoft Access Driver (*.mdb)};
//		DBQ=D:\\Program Files\\Microsoft Office\\Office10\\Samples\\Northwind.mdb;UID=;PWD=;");
//		cn= new OdbcConnection("Driver={Microsoft ODBC for Oracle};Server=myOracleServer;
//		UID=demo;PWD=demo;");
//		cn= new OdbcConnection("dsn=myDSN;UID=myUid;PWD=myPwd;");
//		cmd=new OdbcCommand(MyString,cn);



		//SQLs郁\bh
		//Y1ȏ゠ꍇ́ACSVt@Co͂[őt
		public void ExecSql(string sql,string outputFileName,bool mailExecute,string mailFrom,
			string mailTo,string mailCc ,string mailSmtp,string mailTitle,string mailText)
		{
			string cmdSql= sql;
			long lCnt = 0;

			IDataReader myReader = null;
			try
			{


				//ϐConn̒lɂďU蕪
				if ("System.Data.OracleClient.OracleConnection" == conn.GetType().ToString())
				{
					//SQLsAOracleDataReaderɕۑ܂B
					Console.WriteLine("SQLs(Oracle)");
					OracleCommand cmd = new OracleCommand(cmdSql, (OracleConnection)conn);
					myReader = cmd.ExecuteReader();
				}
				else if( "System.Data.SqlClient.SqlConnection" == conn.GetType().ToString() ) 
				{
					Console.WriteLine("SQLs(SQLServer)");
					SqlCommand cmd = new SqlCommand(cmdSql, (SqlConnection)conn);
					myReader = cmd.ExecuteReader();
				}
				else if( "System.Data.Odbc.OdbcConnection" == conn.GetType().ToString() ) 
				{
					Console.WriteLine("SQLs(ODBC)");
					OdbcCommand cmd = new OdbcCommand(cmdSql, (OdbcConnection)conn);
					myReader = cmd.ExecuteReader();
				}

				//CSVo͗pStreamWriter܂(Shift-JIS)B
				StreamWriter sw =
					new StreamWriter(outputFileName, false, System.Text.Encoding.GetEncoding("Shift-JIS"));

				//SQL̎sʂ̌񃋁[v܂B
				while(myReader.Read()) 
				{
					OutputHeader(sw , myReader,lCnt);           //wb_[p̗񖼂o
					OutputValue(sw,myReader);  					//lo
					lCnt ++;
				}

				myReader.Close();
				sw.Close();			
			}

			catch(Exception ex)
			{
				Console.WriteLine("SQLsɃG[");
				Console.WriteLine(ex.Message);
				Console.WriteLine(ex.Source);
				Console.WriteLine(ex.StackTrace);
				throw new Exception(ex.Message + "\n\n" + sql + "\n\no̓t@CF" +outputFileName + "\n\n()SQL̍Ō;/͕Kv܂B",ex);
			}

			//Y1ȏ゠A[T[o̐ݒ肪Ăꍇ́A[CSVt@C𑗕t܂B
			if (lCnt != 0)
			{
				if (mailExecute == true)
				{
					SendMail(outputFileName,mailFrom,mailTo,mailCc ,mailSmtp,mailTitle,mailText);
				}
			}
		}

		//DBƂ̐ؒfs\bh
		public void DisConnect()
			{
				Console.WriteLine("DBؒf");
				if (conn != null)
					conn.Close();
					conn.Dispose();
			}
			
		//񖼂wb_[ƂCSV`ŏo͂郁\bh
		private void OutputHeader(StreamWriter sr,IDataReader myReader,long lCnt)
		{
			if (lCnt == 0)
			{

				for (int i = 0; i < myReader.FieldCount; i++)
				{
					sr.Write(myReader.GetName(i));
					if ( i < myReader.FieldCount-1 )
					{
						sr.Write(",");  //R}؂
					}
				}
				sr.WriteLine(""); //s
			}
		}

		//ʂCSV`ŏo͂郁\bh
		private void OutputValue(StreamWriter sr,IDataReader myReader)
		{

			for (int i = 0 ; i < myReader.FieldCount; i++)
			{
				sr.Write(myReader.GetValue(i));
				if ( i < myReader.FieldCount-1 )
				{
					sr.Write(",");  //R}؂
				}
			}
			sr.WriteLine(""); //s
		}


		//[𑗐M郁\bh
		private void SendMail(string outputFileName,string mailFrom,
			string mailTo,string mailCc ,string mailSmtp,string mailTitle,string mailText)
		{
			try
			{
				Console.WriteLine("[M");
				System.Web.Mail.SmtpMail.SmtpServer = mailSmtp;

				System.Web.Mail.MailMessage message
					= new System.Web.Mail.MailMessage();
				message.From =mailFrom;
				message.To = mailTo;
				message.Cc = mailCc;
				if ( mailTitle == "" )
				{
					message.Subject = "[M]" + outputFileName.Substring(outputFileName.LastIndexOf("\\")+1
						,outputFileName.Length-((outputFileName.LastIndexOf("\\")+1)));
				}
				else
				{
					message.Subject = mailTitle;
				}
				message.BodyEncoding = System.Text.Encoding.UTF8;
				message.BodyFormat = System.Web.Mail.MailFormat.Text;

				message.Body = mailText;


				System.Web.Mail.MailAttachment attachment = new System.Web.Mail.MailAttachment(
					outputFileName,System.Web.Mail.MailEncoding.Base64);
				message.Attachments.Add(attachment); 


				System.Web.Mail.SmtpMail.Send(message);
			}
			catch(Exception ex){
				Console.WriteLine("[MsɃG[");
				Console.WriteLine(ex.Message);
				Console.WriteLine(ex.Source);
				Console.WriteLine(ex.StackTrace);
				throw new Exception("[̑MɃG[܂B\nSMTP̐ݒmFĂ\n" + ex.Message ,ex);
			}
}
	}
}


