using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using DBConnect;
using System.IO;
using System.Text;
using System.Diagnostics;


namespace DataUnit
{
	/// <summary>
	/// Form1 ̊Tv̐łB
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnExecSql;
		private System.Windows.Forms.FolderBrowserDialog fbdDir;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.GroupBox grpMail;
		private System.Windows.Forms.Label lblMailSmtp;
		private System.Windows.Forms.Label lblMailCc;
		private System.Windows.Forms.Label lblMailTo;
		private System.Windows.Forms.TextBox txtMailTo;
		private System.Windows.Forms.Label lblMailFrom;
		private System.Windows.Forms.TextBox txtMailFrom;
		private System.Windows.Forms.TextBox txtMailCc;
		private System.Windows.Forms.TextBox txtMailSmtp;
		private System.Windows.Forms.GroupBox grpDir;
		private System.Windows.Forms.Button btnDirResult;
		private System.Windows.Forms.TextBox txtDirResult;
		private System.Windows.Forms.Label lblDirResult;
		private System.Windows.Forms.TextBox txtDirSql;
		private System.Windows.Forms.Button btnDirSql;
		private System.Windows.Forms.Label lblDirSql;
		private System.Windows.Forms.Timer timRepeatExecute;
		private System.Windows.Forms.LinkLabel lnkManual;
		private System.Windows.Forms.Label lblVersion;
		private System.Windows.Forms.LinkLabel lnkHomePage;
		private System.Windows.Forms.TabControl tabConnect;
		private System.Windows.Forms.TabPage tabOracle;
		private System.Windows.Forms.TabPage tabSqlServer;
		private System.Windows.Forms.Label lblService;
		private System.Windows.Forms.TextBox txtServiceName;
		private System.Windows.Forms.Label lblPass;
		private System.Windows.Forms.TextBox txtPassword;
		private System.Windows.Forms.Label lblUser;
		private System.Windows.Forms.TextBox txtUser;
		private System.Windows.Forms.Label lblSeverSS;
		private System.Windows.Forms.TextBox txtServerSS;
		private System.Windows.Forms.Label lblPasswordSS;
		private System.Windows.Forms.TextBox txtPasswordSS;
		private System.Windows.Forms.Label lblUserSS;
		private System.Windows.Forms.TextBox txtUserSS;
		private System.Windows.Forms.Label lblDatabase;
		private System.Windows.Forms.TextBox txtDatabaseSS;
		private System.Windows.Forms.Label lblTab;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.CheckBox chkSync;
		private System.Windows.Forms.TextBox txtSync;
		private System.Windows.Forms.Button btnExpSql;
		private System.Windows.Forms.Button btnExpResult;
		private System.Windows.Forms.TabPage tabOdbc;
		private System.Windows.Forms.Label lblPasswordOdbc;
		private System.Windows.Forms.TextBox txtPasswordOdbc;
		private System.Windows.Forms.Label lblUserOdbc;
		private System.Windows.Forms.TextBox txtUserOdbc;
		private System.Windows.Forms.Label lblOdbcDsn;
		private System.Windows.Forms.TextBox txtOdbcDsn;
		private System.Windows.Forms.TabPage tabAccess;
		private System.Windows.Forms.Label lblMdbPath;
		private System.Windows.Forms.TextBox txtMdbPath;
		private System.Windows.Forms.Button btnDirMdb;
		private System.Windows.Forms.OpenFileDialog ofdDir;
		private System.Windows.Forms.CheckBox chkSelectOnly;
		private System.Windows.Forms.Label lbtTitle;
		private System.Windows.Forms.CheckBox chkMailExecute;
		private System.Windows.Forms.TextBox txtMailText;
		private System.Windows.Forms.TextBox txtMailTitle;

		public string m_config_text_name = "CONFIG.TXT";

		public frmMain()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmMain));
			this.btnExecSql = new System.Windows.Forms.Button();
			this.fbdDir = new System.Windows.Forms.FolderBrowserDialog();
			this.btnClose = new System.Windows.Forms.Button();
			this.grpMail = new System.Windows.Forms.GroupBox();
			this.txtMailText = new System.Windows.Forms.TextBox();
			this.lbtTitle = new System.Windows.Forms.Label();
			this.txtMailTitle = new System.Windows.Forms.TextBox();
			this.txtMailSmtp = new System.Windows.Forms.TextBox();
			this.txtMailCc = new System.Windows.Forms.TextBox();
			this.txtMailFrom = new System.Windows.Forms.TextBox();
			this.lblMailFrom = new System.Windows.Forms.Label();
			this.lblMailSmtp = new System.Windows.Forms.Label();
			this.lblMailCc = new System.Windows.Forms.Label();
			this.lblMailTo = new System.Windows.Forms.Label();
			this.txtMailTo = new System.Windows.Forms.TextBox();
			this.grpDir = new System.Windows.Forms.GroupBox();
			this.btnExpResult = new System.Windows.Forms.Button();
			this.btnExpSql = new System.Windows.Forms.Button();
			this.txtSync = new System.Windows.Forms.TextBox();
			this.chkSync = new System.Windows.Forms.CheckBox();
			this.btnDirResult = new System.Windows.Forms.Button();
			this.txtDirResult = new System.Windows.Forms.TextBox();
			this.lblDirResult = new System.Windows.Forms.Label();
			this.txtDirSql = new System.Windows.Forms.TextBox();
			this.btnDirSql = new System.Windows.Forms.Button();
			this.lblDirSql = new System.Windows.Forms.Label();
			this.timRepeatExecute = new System.Windows.Forms.Timer(this.components);
			this.lnkHomePage = new System.Windows.Forms.LinkLabel();
			this.lnkManual = new System.Windows.Forms.LinkLabel();
			this.lblVersion = new System.Windows.Forms.Label();
			this.tabConnect = new System.Windows.Forms.TabControl();
			this.tabOracle = new System.Windows.Forms.TabPage();
			this.lblService = new System.Windows.Forms.Label();
			this.txtServiceName = new System.Windows.Forms.TextBox();
			this.lblPass = new System.Windows.Forms.Label();
			this.txtPassword = new System.Windows.Forms.TextBox();
			this.lblUser = new System.Windows.Forms.Label();
			this.txtUser = new System.Windows.Forms.TextBox();
			this.tabSqlServer = new System.Windows.Forms.TabPage();
			this.lblDatabase = new System.Windows.Forms.Label();
			this.txtDatabaseSS = new System.Windows.Forms.TextBox();
			this.lblSeverSS = new System.Windows.Forms.Label();
			this.txtServerSS = new System.Windows.Forms.TextBox();
			this.lblPasswordSS = new System.Windows.Forms.Label();
			this.txtPasswordSS = new System.Windows.Forms.TextBox();
			this.lblUserSS = new System.Windows.Forms.Label();
			this.txtUserSS = new System.Windows.Forms.TextBox();
			this.tabOdbc = new System.Windows.Forms.TabPage();
			this.lblOdbcDsn = new System.Windows.Forms.Label();
			this.txtOdbcDsn = new System.Windows.Forms.TextBox();
			this.lblPasswordOdbc = new System.Windows.Forms.Label();
			this.txtPasswordOdbc = new System.Windows.Forms.TextBox();
			this.lblUserOdbc = new System.Windows.Forms.Label();
			this.txtUserOdbc = new System.Windows.Forms.TextBox();
			this.tabAccess = new System.Windows.Forms.TabPage();
			this.lblMdbPath = new System.Windows.Forms.Label();
			this.txtMdbPath = new System.Windows.Forms.TextBox();
			this.btnDirMdb = new System.Windows.Forms.Button();
			this.lblTab = new System.Windows.Forms.Label();
			this.chkSelectOnly = new System.Windows.Forms.CheckBox();
			this.ofdDir = new System.Windows.Forms.OpenFileDialog();
			this.chkMailExecute = new System.Windows.Forms.CheckBox();
			this.grpMail.SuspendLayout();
			this.grpDir.SuspendLayout();
			this.tabConnect.SuspendLayout();
			this.tabOracle.SuspendLayout();
			this.tabSqlServer.SuspendLayout();
			this.tabOdbc.SuspendLayout();
			this.tabAccess.SuspendLayout();
			this.SuspendLayout();
			// 
			// btnExecSql
			// 
			this.btnExecSql.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnExecSql.Location = new System.Drawing.Point(8, 368);
			this.btnExecSql.Name = "btnExecSql";
			this.btnExecSql.Size = new System.Drawing.Size(216, 24);
			this.btnExecSql.TabIndex = 4;
			this.btnExecSql.Text = "SQL̎si&Ej";
			this.btnExecSql.Click += new System.EventHandler(this.btnExecSql_Click);
			// 
			// btnClose
			// 
			this.btnClose.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnClose.Location = new System.Drawing.Point(224, 368);
			this.btnClose.Name = "btnClose";
			this.btnClose.Size = new System.Drawing.Size(216, 24);
			this.btnClose.TabIndex = 5;
			this.btnClose.Text = "";
			this.btnClose.Click += new System.EventHandler(this.btnColose_Click);
			// 
			// grpMail
			// 
			this.grpMail.Controls.Add(this.txtMailText);
			this.grpMail.Controls.Add(this.lbtTitle);
			this.grpMail.Controls.Add(this.txtMailTitle);
			this.grpMail.Controls.Add(this.txtMailSmtp);
			this.grpMail.Controls.Add(this.txtMailCc);
			this.grpMail.Controls.Add(this.txtMailFrom);
			this.grpMail.Controls.Add(this.lblMailFrom);
			this.grpMail.Controls.Add(this.lblMailSmtp);
			this.grpMail.Controls.Add(this.lblMailCc);
			this.grpMail.Controls.Add(this.lblMailTo);
			this.grpMail.Controls.Add(this.txtMailTo);
			this.grpMail.Location = new System.Drawing.Point(8, 244);
			this.grpMail.Name = "grpMail";
			this.grpMail.Size = new System.Drawing.Size(432, 120);
			this.grpMail.TabIndex = 3;
			this.grpMail.TabStop = false;
			this.grpMail.Text = "@@@@@@@@@@@";
			// 
			// txtMailText
			// 
			this.txtMailText.Font = new System.Drawing.Font("MS UI Gothic", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
			this.txtMailText.ForeColor = System.Drawing.SystemColors.WindowText;
			this.txtMailText.Location = new System.Drawing.Point(236, 40);
			this.txtMailText.Multiline = true;
			this.txtMailText.Name = "txtMailText";
			this.txtMailText.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.txtMailText.Size = new System.Drawing.Size(192, 76);
			this.txtMailText.TabIndex = 10;
			this.txtMailText.Text = "`̃[͎Mł`B\r\n\r\nDataUnitSQLɊYf[^邽߁A\r\nsʂCSVt@CɂēYt܂B\r\n\r\n---\r\nhttp:" +
				"//sourceforge.jp/projects/dataunit/";
			// 
			// lbtTitle
			// 
			this.lbtTitle.Location = new System.Drawing.Point(236, 24);
			this.lbtTitle.Name = "lbtTitle";
			this.lbtTitle.Size = new System.Drawing.Size(60, 16);
			this.lbtTitle.TabIndex = 8;
			this.lbtTitle.Text = "/{";
			// 
			// txtMailTitle
			// 
			this.txtMailTitle.Font = new System.Drawing.Font("MS UI Gothic", 9F);
			this.txtMailTitle.ForeColor = System.Drawing.SystemColors.WindowText;
			this.txtMailTitle.Location = new System.Drawing.Point(300, 20);
			this.txtMailTitle.Name = "txtMailTitle";
			this.txtMailTitle.Size = new System.Drawing.Size(128, 19);
			this.txtMailTitle.TabIndex = 7;
			this.txtMailTitle.Text = "";
			// 
			// txtMailSmtp
			// 
			this.txtMailSmtp.Location = new System.Drawing.Point(80, 84);
			this.txtMailSmtp.Name = "txtMailSmtp";
			this.txtMailSmtp.Size = new System.Drawing.Size(148, 19);
			this.txtMailSmtp.TabIndex = 3;
			this.txtMailSmtp.Text = "sample.dataunit.sourceforge.jp";
			// 
			// txtMailCc
			// 
			this.txtMailCc.Location = new System.Drawing.Point(48, 60);
			this.txtMailCc.Name = "txtMailCc";
			this.txtMailCc.Size = new System.Drawing.Size(180, 19);
			this.txtMailCc.TabIndex = 2;
			this.txtMailCc.Text = "cc1@dataunit.sourceforge.jp;cc2@dataunit.sourceforge.jp";
			// 
			// txtMailFrom
			// 
			this.txtMailFrom.ForeColor = System.Drawing.SystemColors.WindowText;
			this.txtMailFrom.Location = new System.Drawing.Point(48, 20);
			this.txtMailFrom.Name = "txtMailFrom";
			this.txtMailFrom.Size = new System.Drawing.Size(180, 19);
			this.txtMailFrom.TabIndex = 0;
			this.txtMailFrom.Text = "from@dataunit.sourceforge.jp";
			// 
			// lblMailFrom
			// 
			this.lblMailFrom.Location = new System.Drawing.Point(12, 24);
			this.lblMailFrom.Name = "lblMailFrom";
			this.lblMailFrom.Size = new System.Drawing.Size(32, 16);
			this.lblMailFrom.TabIndex = 6;
			this.lblMailFrom.Text = "From";
			// 
			// lblMailSmtp
			// 
			this.lblMailSmtp.Location = new System.Drawing.Point(12, 88);
			this.lblMailSmtp.Name = "lblMailSmtp";
			this.lblMailSmtp.Size = new System.Drawing.Size(108, 16);
			this.lblMailSmtp.TabIndex = 5;
			this.lblMailSmtp.Text = "SMTPT[o";
			// 
			// lblMailCc
			// 
			this.lblMailCc.Location = new System.Drawing.Point(12, 64);
			this.lblMailCc.Name = "lblMailCc";
			this.lblMailCc.Size = new System.Drawing.Size(32, 16);
			this.lblMailCc.TabIndex = 3;
			this.lblMailCc.Text = "Cc";
			// 
			// lblMailTo
			// 
			this.lblMailTo.Location = new System.Drawing.Point(12, 44);
			this.lblMailTo.Name = "lblMailTo";
			this.lblMailTo.Size = new System.Drawing.Size(28, 16);
			this.lblMailTo.TabIndex = 1;
			this.lblMailTo.Text = "To";
			// 
			// txtMailTo
			// 
			this.txtMailTo.Location = new System.Drawing.Point(48, 40);
			this.txtMailTo.Name = "txtMailTo";
			this.txtMailTo.Size = new System.Drawing.Size(180, 19);
			this.txtMailTo.TabIndex = 1;
			this.txtMailTo.Text = "to@dataunit.sourceforge.jp";
			// 
			// grpDir
			// 
			this.grpDir.Controls.Add(this.btnExpResult);
			this.grpDir.Controls.Add(this.btnExpSql);
			this.grpDir.Controls.Add(this.txtSync);
			this.grpDir.Controls.Add(this.chkSync);
			this.grpDir.Controls.Add(this.btnDirResult);
			this.grpDir.Controls.Add(this.txtDirResult);
			this.grpDir.Controls.Add(this.lblDirResult);
			this.grpDir.Controls.Add(this.txtDirSql);
			this.grpDir.Controls.Add(this.btnDirSql);
			this.grpDir.Controls.Add(this.lblDirSql);
			this.grpDir.Location = new System.Drawing.Point(8, 100);
			this.grpDir.Name = "grpDir";
			this.grpDir.Size = new System.Drawing.Size(432, 132);
			this.grpDir.TabIndex = 2;
			this.grpDir.TabStop = false;
			this.grpDir.Text = "tH_ݒ";
			// 
			// btnExpResult
			// 
			this.btnExpResult.Font = new System.Drawing.Font("MS UI Gothic", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
			this.btnExpResult.Location = new System.Drawing.Point(378, 80);
			this.btnExpResult.Name = "btnExpResult";
			this.btnExpResult.Size = new System.Drawing.Size(50, 20);
			this.btnExpResult.TabIndex = 5;
			this.btnExpResult.Text = "Explorer";
			this.btnExpResult.Click += new System.EventHandler(this.btnExpResult_Click);
			// 
			// btnExpSql
			// 
			this.btnExpSql.Font = new System.Drawing.Font("MS UI Gothic", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
			this.btnExpSql.Location = new System.Drawing.Point(378, 32);
			this.btnExpSql.Name = "btnExpSql";
			this.btnExpSql.Size = new System.Drawing.Size(50, 20);
			this.btnExpSql.TabIndex = 2;
			this.btnExpSql.Text = "Explorer";
			this.btnExpSql.Click += new System.EventHandler(this.btnExpSql_Click);
			// 
			// txtSync
			// 
			this.txtSync.Enabled = false;
			this.txtSync.Location = new System.Drawing.Point(160, 100);
			this.txtSync.Name = "txtSync";
			this.txtSync.Size = new System.Drawing.Size(168, 19);
			this.txtSync.TabIndex = 7;
			this.txtSync.Text = "";
			this.txtSync.TextChanged += new System.EventHandler(this.txtSync_TextChanged);
			// 
			// chkSync
			// 
			this.chkSync.Checked = true;
			this.chkSync.CheckState = System.Windows.Forms.CheckState.Checked;
			this.chkSync.Location = new System.Drawing.Point(12, 102);
			this.chkSync.Name = "chkSync";
			this.chkSync.Size = new System.Drawing.Size(196, 16);
			this.chkSync.TabIndex = 6;
			this.chkSync.Text = "SQLtH_Ɠ";
			this.chkSync.CheckedChanged += new System.EventHandler(this.chkSync_CheckedChanged);
			// 
			// btnDirResult
			// 
			this.btnDirResult.Location = new System.Drawing.Point(328, 80);
			this.btnDirResult.Name = "btnDirResult";
			this.btnDirResult.Size = new System.Drawing.Size(50, 20);
			this.btnDirResult.TabIndex = 4;
			this.btnDirResult.Text = "Q";
			this.btnDirResult.Click += new System.EventHandler(this.btnDirResult_Click);
			// 
			// txtDirResult
			// 
			this.txtDirResult.Location = new System.Drawing.Point(12, 80);
			this.txtDirResult.Name = "txtDirResult";
			this.txtDirResult.Size = new System.Drawing.Size(316, 19);
			this.txtDirResult.TabIndex = 3;
			this.txtDirResult.Text = "C:\\Program Files\\DataUnit\\CheckSql";
			this.txtDirResult.TextChanged += new System.EventHandler(this.txtDirResult_TextChanged);
			// 
			// lblDirResult
			// 
			this.lblDirResult.Location = new System.Drawing.Point(8, 64);
			this.lblDirResult.Name = "lblDirResult";
			this.lblDirResult.Size = new System.Drawing.Size(380, 24);
			this.lblDirResult.TabIndex = 0;
			this.lblDirResult.Text = "ʂo͂tH_(ut@C{^CX^v{.csvvɂďo)";
			// 
			// txtDirSql
			// 
			this.txtDirSql.Location = new System.Drawing.Point(12, 32);
			this.txtDirSql.Name = "txtDirSql";
			this.txtDirSql.Size = new System.Drawing.Size(316, 19);
			this.txtDirSql.TabIndex = 0;
			this.txtDirSql.Text = "C:\\Program Files\\DataUnit\\CheckSql";
			this.txtDirSql.TextChanged += new System.EventHandler(this.txtDirSql_TextChanged);
			// 
			// btnDirSql
			// 
			this.btnDirSql.Location = new System.Drawing.Point(328, 32);
			this.btnDirSql.Name = "btnDirSql";
			this.btnDirSql.Size = new System.Drawing.Size(50, 20);
			this.btnDirSql.TabIndex = 1;
			this.btnDirSql.Text = "Q";
			this.btnDirSql.Click += new System.EventHandler(this.btnDirSql_Click);
			// 
			// lblDirSql
			// 
			this.lblDirSql.Location = new System.Drawing.Point(8, 16);
			this.lblDirSql.Name = "lblDirSql";
			this.lblDirSql.Size = new System.Drawing.Size(320, 24);
			this.lblDirSql.TabIndex = 12;
			this.lblDirSql.Text = "SQL݂tH_iu*.sqlvsΏہj";
			// 
			// timRepeatExecute
			// 
			this.timRepeatExecute.Interval = 10000;
			this.timRepeatExecute.Tick += new System.EventHandler(this.timRepeatExecute_Tick);
			// 
			// lnkHomePage
			// 
			this.lnkHomePage.Location = new System.Drawing.Point(320, 400);
			this.lnkHomePage.Name = "lnkHomePage";
			this.lnkHomePage.Size = new System.Drawing.Size(68, 20);
			this.lnkHomePage.TabIndex = 8;
			this.lnkHomePage.TabStop = true;
			this.lnkHomePage.Text = "HomePage";
			this.lnkHomePage.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lnkHomePage_LinkClicked);
			// 
			// lnkManual
			// 
			this.lnkManual.Location = new System.Drawing.Point(384, 400);
			this.lnkManual.Name = "lnkManual";
			this.lnkManual.Size = new System.Drawing.Size(56, 20);
			this.lnkManual.TabIndex = 9;
			this.lnkManual.TabStop = true;
			this.lnkManual.Text = "}jA";
			this.lnkManual.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lnkManual_LinkClicked);
			// 
			// lblVersion
			// 
			this.lblVersion.Location = new System.Drawing.Point(216, 400);
			this.lblVersion.Name = "lblVersion";
			this.lblVersion.Size = new System.Drawing.Size(104, 16);
			this.lblVersion.TabIndex = 7;
			this.lblVersion.Text = "DataUnit Ver.2.0.1";
			// 
			// tabConnect
			// 
			this.tabConnect.Controls.Add(this.tabOracle);
			this.tabConnect.Controls.Add(this.tabSqlServer);
			this.tabConnect.Controls.Add(this.tabOdbc);
			this.tabConnect.Controls.Add(this.tabAccess);
			this.tabConnect.Location = new System.Drawing.Point(8, 4);
			this.tabConnect.Name = "tabConnect";
			this.tabConnect.SelectedIndex = 0;
			this.tabConnect.Size = new System.Drawing.Size(432, 72);
			this.tabConnect.TabIndex = 0;
			// 
			// tabOracle
			// 
			this.tabOracle.Controls.Add(this.lblService);
			this.tabOracle.Controls.Add(this.txtServiceName);
			this.tabOracle.Controls.Add(this.lblPass);
			this.tabOracle.Controls.Add(this.txtPassword);
			this.tabOracle.Controls.Add(this.lblUser);
			this.tabOracle.Controls.Add(this.txtUser);
			this.tabOracle.Location = new System.Drawing.Point(4, 21);
			this.tabOracle.Name = "tabOracle";
			this.tabOracle.Size = new System.Drawing.Size(424, 47);
			this.tabOracle.TabIndex = 0;
			this.tabOracle.Text = "  Oracleڑ  ";
			// 
			// lblService
			// 
			this.lblService.Location = new System.Drawing.Point(184, 8);
			this.lblService.Name = "lblService";
			this.lblService.Size = new System.Drawing.Size(120, 16);
			this.lblService.TabIndex = 4;
			this.lblService.Text = "ڑiT[rXj";
			// 
			// txtServiceName
			// 
			this.txtServiceName.Location = new System.Drawing.Point(184, 24);
			this.txtServiceName.Name = "txtServiceName";
			this.txtServiceName.Size = new System.Drawing.Size(112, 19);
			this.txtServiceName.TabIndex = 5;
			this.txtServiceName.Text = "ora_service";
			// 
			// lblPass
			// 
			this.lblPass.Location = new System.Drawing.Point(96, 8);
			this.lblPass.Name = "lblPass";
			this.lblPass.Size = new System.Drawing.Size(80, 16);
			this.lblPass.TabIndex = 2;
			this.lblPass.Text = "pX[h";
			// 
			// txtPassword
			// 
			this.txtPassword.Location = new System.Drawing.Point(96, 24);
			this.txtPassword.Name = "txtPassword";
			this.txtPassword.PasswordChar = '*';
			this.txtPassword.Size = new System.Drawing.Size(88, 19);
			this.txtPassword.TabIndex = 3;
			this.txtPassword.Text = "tiger";
			// 
			// lblUser
			// 
			this.lblUser.Location = new System.Drawing.Point(8, 8);
			this.lblUser.Name = "lblUser";
			this.lblUser.Size = new System.Drawing.Size(80, 16);
			this.lblUser.TabIndex = 0;
			this.lblUser.Text = "[U";
			// 
			// txtUser
			// 
			this.txtUser.Location = new System.Drawing.Point(8, 24);
			this.txtUser.Name = "txtUser";
			this.txtUser.Size = new System.Drawing.Size(88, 19);
			this.txtUser.TabIndex = 1;
			this.txtUser.Text = "scott";
			// 
			// tabSqlServer
			// 
			this.tabSqlServer.Controls.Add(this.lblDatabase);
			this.tabSqlServer.Controls.Add(this.txtDatabaseSS);
			this.tabSqlServer.Controls.Add(this.lblSeverSS);
			this.tabSqlServer.Controls.Add(this.txtServerSS);
			this.tabSqlServer.Controls.Add(this.lblPasswordSS);
			this.tabSqlServer.Controls.Add(this.txtPasswordSS);
			this.tabSqlServer.Controls.Add(this.lblUserSS);
			this.tabSqlServer.Controls.Add(this.txtUserSS);
			this.tabSqlServer.Location = new System.Drawing.Point(4, 21);
			this.tabSqlServer.Name = "tabSqlServer";
			this.tabSqlServer.Size = new System.Drawing.Size(424, 47);
			this.tabSqlServer.TabIndex = 1;
			this.tabSqlServer.Text = "SQL Serverڑ";
			// 
			// lblDatabase
			// 
			this.lblDatabase.Location = new System.Drawing.Point(280, 8);
			this.lblDatabase.Name = "lblDatabase";
			this.lblDatabase.Size = new System.Drawing.Size(88, 16);
			this.lblDatabase.TabIndex = 19;
			this.lblDatabase.Text = "f[^x[X";
			// 
			// txtDatabaseSS
			// 
			this.txtDatabaseSS.Location = new System.Drawing.Point(280, 24);
			this.txtDatabaseSS.Name = "txtDatabaseSS";
			this.txtDatabaseSS.Size = new System.Drawing.Size(88, 19);
			this.txtDatabaseSS.TabIndex = 18;
			this.txtDatabaseSS.Text = "pubs";
			// 
			// lblSeverSS
			// 
			this.lblSeverSS.Location = new System.Drawing.Point(184, 8);
			this.lblSeverSS.Name = "lblSeverSS";
			this.lblSeverSS.Size = new System.Drawing.Size(88, 16);
			this.lblSeverSS.TabIndex = 17;
			this.lblSeverSS.Text = "T[o";
			// 
			// txtServerSS
			// 
			this.txtServerSS.Location = new System.Drawing.Point(184, 24);
			this.txtServerSS.Name = "txtServerSS";
			this.txtServerSS.Size = new System.Drawing.Size(96, 19);
			this.txtServerSS.TabIndex = 15;
			this.txtServerSS.Text = "(local)\\NETSDK";
			// 
			// lblPasswordSS
			// 
			this.lblPasswordSS.Location = new System.Drawing.Point(96, 8);
			this.lblPasswordSS.Name = "lblPasswordSS";
			this.lblPasswordSS.Size = new System.Drawing.Size(80, 16);
			this.lblPasswordSS.TabIndex = 16;
			this.lblPasswordSS.Text = "pX[h";
			// 
			// txtPasswordSS
			// 
			this.txtPasswordSS.Location = new System.Drawing.Point(96, 24);
			this.txtPasswordSS.Name = "txtPasswordSS";
			this.txtPasswordSS.PasswordChar = '*';
			this.txtPasswordSS.Size = new System.Drawing.Size(88, 19);
			this.txtPasswordSS.TabIndex = 14;
			this.txtPasswordSS.Text = "sa_admin_pass";
			// 
			// lblUserSS
			// 
			this.lblUserSS.Location = new System.Drawing.Point(8, 8);
			this.lblUserSS.Name = "lblUserSS";
			this.lblUserSS.Size = new System.Drawing.Size(80, 16);
			this.lblUserSS.TabIndex = 13;
			this.lblUserSS.Text = "[U";
			// 
			// txtUserSS
			// 
			this.txtUserSS.Location = new System.Drawing.Point(8, 24);
			this.txtUserSS.Name = "txtUserSS";
			this.txtUserSS.Size = new System.Drawing.Size(88, 19);
			this.txtUserSS.TabIndex = 12;
			this.txtUserSS.Text = "sa";
			// 
			// tabOdbc
			// 
			this.tabOdbc.Controls.Add(this.lblOdbcDsn);
			this.tabOdbc.Controls.Add(this.txtOdbcDsn);
			this.tabOdbc.Controls.Add(this.lblPasswordOdbc);
			this.tabOdbc.Controls.Add(this.txtPasswordOdbc);
			this.tabOdbc.Controls.Add(this.lblUserOdbc);
			this.tabOdbc.Controls.Add(this.txtUserOdbc);
			this.tabOdbc.Location = new System.Drawing.Point(4, 21);
			this.tabOdbc.Name = "tabOdbc";
			this.tabOdbc.Size = new System.Drawing.Size(424, 47);
			this.tabOdbc.TabIndex = 2;
			this.tabOdbc.Text = "  ODBCڑ  ";
			// 
			// lblOdbcDsn
			// 
			this.lblOdbcDsn.Location = new System.Drawing.Point(184, 8);
			this.lblOdbcDsn.Name = "lblOdbcDsn";
			this.lblOdbcDsn.Size = new System.Drawing.Size(88, 16);
			this.lblOdbcDsn.TabIndex = 23;
			this.lblOdbcDsn.Text = "f[^\[X";
			// 
			// txtOdbcDsn
			// 
			this.txtOdbcDsn.Location = new System.Drawing.Point(184, 24);
			this.txtOdbcDsn.Name = "txtOdbcDsn";
			this.txtOdbcDsn.Size = new System.Drawing.Size(96, 19);
			this.txtOdbcDsn.TabIndex = 2;
			this.txtOdbcDsn.Text = "MyOdbcDsn";
			// 
			// lblPasswordOdbc
			// 
			this.lblPasswordOdbc.Location = new System.Drawing.Point(96, 8);
			this.lblPasswordOdbc.Name = "lblPasswordOdbc";
			this.lblPasswordOdbc.Size = new System.Drawing.Size(80, 16);
			this.lblPasswordOdbc.TabIndex = 22;
			this.lblPasswordOdbc.Text = "pX[h";
			// 
			// txtPasswordOdbc
			// 
			this.txtPasswordOdbc.Location = new System.Drawing.Point(96, 24);
			this.txtPasswordOdbc.Name = "txtPasswordOdbc";
			this.txtPasswordOdbc.PasswordChar = '*';
			this.txtPasswordOdbc.Size = new System.Drawing.Size(88, 19);
			this.txtPasswordOdbc.TabIndex = 1;
			this.txtPasswordOdbc.Text = "sa_admin_pass";
			// 
			// lblUserOdbc
			// 
			this.lblUserOdbc.Location = new System.Drawing.Point(8, 8);
			this.lblUserOdbc.Name = "lblUserOdbc";
			this.lblUserOdbc.Size = new System.Drawing.Size(80, 16);
			this.lblUserOdbc.TabIndex = 19;
			this.lblUserOdbc.Text = "[U";
			// 
			// txtUserOdbc
			// 
			this.txtUserOdbc.Location = new System.Drawing.Point(8, 24);
			this.txtUserOdbc.Name = "txtUserOdbc";
			this.txtUserOdbc.Size = new System.Drawing.Size(88, 19);
			this.txtUserOdbc.TabIndex = 0;
			this.txtUserOdbc.Text = "sa";
			// 
			// tabAccess
			// 
			this.tabAccess.Controls.Add(this.lblMdbPath);
			this.tabAccess.Controls.Add(this.txtMdbPath);
			this.tabAccess.Controls.Add(this.btnDirMdb);
			this.tabAccess.Location = new System.Drawing.Point(4, 21);
			this.tabAccess.Name = "tabAccess";
			this.tabAccess.Size = new System.Drawing.Size(424, 47);
			this.tabAccess.TabIndex = 3;
			this.tabAccess.Text = "MsAccessڑ";
			// 
			// lblMdbPath
			// 
			this.lblMdbPath.Location = new System.Drawing.Point(8, 8);
			this.lblMdbPath.Name = "lblMdbPath";
			this.lblMdbPath.Size = new System.Drawing.Size(200, 16);
			this.lblMdbPath.TabIndex = 25;
			this.lblMdbPath.Text = "f[^x[X(u*.mdbvIΏ)";
			// 
			// txtMdbPath
			// 
			this.txtMdbPath.Location = new System.Drawing.Point(8, 24);
			this.txtMdbPath.Name = "txtMdbPath";
			this.txtMdbPath.Size = new System.Drawing.Size(364, 19);
			this.txtMdbPath.TabIndex = 0;
			this.txtMdbPath.Text = "C:\\Program Files\\Microsoft Office\\Office\\Samples\\Northwind.mdb";
			// 
			// btnDirMdb
			// 
			this.btnDirMdb.Location = new System.Drawing.Point(372, 24);
			this.btnDirMdb.Name = "btnDirMdb";
			this.btnDirMdb.Size = new System.Drawing.Size(50, 20);
			this.btnDirMdb.TabIndex = 1;
			this.btnDirMdb.Text = "Q";
			this.btnDirMdb.Click += new System.EventHandler(this.btnDirMdb_Click);
			// 
			// lblTab
			// 
			this.lblTab.Location = new System.Drawing.Point(12, 80);
			this.lblTab.Name = "lblTab";
			this.lblTab.Size = new System.Drawing.Size(368, 12);
			this.lblTab.TabIndex = 1;
			this.lblTab.Text = "݁AIĂ^u̐ڑɑ΂SQLs܂";
			// 
			// chkSelectOnly
			// 
			this.chkSelectOnly.Location = new System.Drawing.Point(16, 396);
			this.chkSelectOnly.Name = "chkSelectOnly";
			this.chkSelectOnly.Size = new System.Drawing.Size(172, 16);
			this.chkSelectOnly.TabIndex = 6;
			this.chkSelectOnly.Text = "SELECT̂ݎs\";
			this.chkSelectOnly.Visible = false;
			// 
			// ofdDir
			// 
			this.ofdDir.FileOk += new System.ComponentModel.CancelEventHandler(this.ofdDir_FileOk);
			// 
			// chkMailExecute
			// 
			this.chkMailExecute.Location = new System.Drawing.Point(20, 244);
			this.chkMailExecute.Name = "chkMailExecute";
			this.chkMailExecute.Size = new System.Drawing.Size(104, 16);
			this.chkMailExecute.TabIndex = 3;
			this.chkMailExecute.Text = "[Mݒ";
			this.chkMailExecute.CheckedChanged += new System.EventHandler(this.chkMailExecute_CheckedChanged);
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(446, 419);
			this.Controls.Add(this.chkMailExecute);
			this.Controls.Add(this.chkSelectOnly);
			this.Controls.Add(this.lblTab);
			this.Controls.Add(this.tabConnect);
			this.Controls.Add(this.lblVersion);
			this.Controls.Add(this.lnkManual);
			this.Controls.Add(this.lnkHomePage);
			this.Controls.Add(this.grpDir);
			this.Controls.Add(this.grpMail);
			this.Controls.Add(this.btnClose);
			this.Controls.Add(this.btnExecSql);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "frmMain";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "DataUnit";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.frmMain_Closing);
			this.Load += new System.EventHandler(this.frmMain_Load);
			this.grpMail.ResumeLayout(false);
			this.grpDir.ResumeLayout(false);
			this.tabConnect.ResumeLayout(false);
			this.tabOracle.ResumeLayout(false);
			this.tabSqlServer.ResumeLayout(false);
			this.tabOdbc.ResumeLayout(false);
			this.tabAccess.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			//ʏ̋N
			if (args.Length == 0 )
			{
				//tH[(frmMain)̃CX^X쐬
				frmMain frm = new frmMain();
				frm.ShowDialog();
				frm = null;
			}
				//R}hCp[^ɂN
			else if(args.Length == 1 )
			{
				//tH[(frmMain)̃CX^X쐬
				frmMain frm = new frmMain();
				frm.m_config_text_name = args[0].ToString();
				//tH[\ȂSQLs
				frm.ReadConfigFile();
				frm.ExecSql();
				frm = null;
			}
			else if(args.Length >= 2 )
			{
				//2ȏ̏ꍇ
				MessageBox.Show("p[^܂B\n() >dataunit.exe CONFIG_ORACLE1.TXT","DataUnit");
			}
		}

		private void btnExecSql_Click(object sender, System.EventArgs e)
		{
			ExecSql();
		}

		public void ExecSql()
		{
			// ̃J[\ێAҋ@J[\ɕύXAtH[ɃbN
			Cursor preCursor = Cursor.Current;
			Cursor.Current = Cursors.WaitCursor;
			this.Enabled = false;
			//bZ[WL[Ɍ݂WindowsbZ[Wׂď(DoEvents)
			System.Windows.Forms.Application.DoEvents();

			string sTitle = "";
			DateTime dtStart = DateTime.Now;
			DateTime dtEnd;

			//DBڑNX̏
			Db db = new Db();
			try
			{
				//fBNgzSQLꗗ擾
				DirectoryInfo dir = new DirectoryInfo(this.txtDirSql.Text);

				//Form̃^CgɎs\
				long lSqlAllCount = dir.GetFiles("*.sql").Length;
				long lSqlCount = 0;
				sTitle = "DataUnit (0/" + lSqlAllCount +") ";
				this.Text = sTitle + dtStart.ToString("HH:mm:ss");
				//DBɐڑ
				DbConnectionInit(db);

				//SQLΌʏo͗ptH_쐬
				if (lSqlAllCount > 0)
				{
					Directory.CreateDirectory(this.txtDirResult.Text);
					this.btnExpResult.Enabled = true;
				}

				foreach (FileInfo f in dir.GetFiles("*.sql")) 
				{
					
					//tH[̃wb_[Ɏs󋵂\
					lSqlCount++;
					sTitle = "DataUnit (" + lSqlCount + "/" + lSqlAllCount +") ";
					this.Text = sTitle + dtStart.ToString("HH:mm:ss");
					Application.DoEvents();
					
					//PSQLǂݏosB
					StreamReader sr = new StreamReader(f.FullName,Encoding.GetEncoding("Shift_JIS"));
					string sqlText = sr.ReadToEnd();

					sr.Close();
					Application.DoEvents();

					//SQL̎s
					db.ExecSql(sqlText,txtDirResult.Text + "\\" + f.Name + "_" + 
						String.Format("{0:yyyyMMdd_HHmmss}",DateTime.Now)+".csv",this.chkMailExecute.Checked,
						this.txtMailFrom.Text,this.txtMailTo.Text,
						this.txtMailCc.Text,this.txtMailSmtp.Text,this.txtMailTitle.Text,this.txtMailText.Text);
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("G[܂B\n\n" + ex.Message ,"mF",
					MessageBoxButtons.OK,MessageBoxIcon.Warning );
			}
			finally
			{
				dtEnd = DateTime.Now;
				//DB̐ؒf
				db.DisConnect();
			}
			// UIAsꂽȂ̂Ŏ኱bSLEEP
			System.Threading.Thread.Sleep(700);

			// tH[̃bNAJ[\ɖ߂
			this.Enabled = true;
			Cursor.Current = preCursor;
			TimeSpan ts = dtEnd - dtStart;
			string sSpan = "";
			if ( ts.Hours > 0 ) 
			{
				sSpan = ts.Hours.ToString("d") + "";
			}
			if(ts.Minutes > 0)
			{
				sSpan = sSpan + ts.Minutes.ToString("d") + "";
			}
			sSpan = sSpan + ts.Seconds.ToString("d") +"b]";

			this.Text = sTitle + dtStart.ToString("HH:mm:ss") +  "" + 
				dtEnd.ToString("HH:mm:ss") + " [" + sSpan;

			Application.DoEvents();
		}
		//tH_ݒp̃_CAO\
		private void btnDirSql_Click(object sender, System.EventArgs e)
		{
			this.fbdDir.SelectedPath  =this.txtDirSql.Text ;
			this.fbdDir.ShowDialog();
			this.txtDirSql.Text =  this.fbdDir.SelectedPath;
		}

		//tH_ݒp̃_CAO\
		private void btnDirResult_Click(object sender, System.EventArgs e)
		{
			this.fbdDir.SelectedPath=this.txtDirResult.Text;
			this.fbdDir.ShowDialog();
			this.txtDirResult.Text =  this.fbdDir.SelectedPath;
		}

		//I{^̏
		private void btnColose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		//tH[̕\̏
		private void frmMain_Load(object sender, System.EventArgs e)
		{
			//ToolTip̒ǉ
			AddToolTip();
			//ݒt@C̓ǂݏo
			ReadConfigFile();
			//[ڂ̐ݒ
			ChangeMailEnable();
			//ʏo̓tH_ݒ
			ControllCheckBox(this.chkSync.Checked);
		}

		//IĂ^uɉāADBڑ̏sB
		private void DbConnectionInit(Db db){
			//DBƐڑ
			if (tabConnect.SelectedIndex == 0)
			{
				//Oracleɐڑ
				db.ConnectOracle(this.txtUser.Text,this.txtPassword.Text,this.txtServiceName.Text);
			} 
			else if(tabConnect.SelectedIndex == 1)
			{
				//SqlServerɐڑ
				db.ConnectSqlServer(this.txtUserSS.Text,this.txtPasswordSS.Text,this.txtServerSS.Text,this.txtDatabaseSS.Text);
			}
			else if(tabConnect.SelectedIndex == 2)
			{
				//ODBCɐڑ
				db.ConnectOdbc(this.txtUserOdbc.Text,this.txtPasswordOdbc.Text,txtOdbcDsn.Text);
			}
			else if(tabConnect.SelectedIndex == 3)
			{
				//Accessɐڑ
				db.ConnectAccess(this.txtMdbPath.Text);
			}		
		
		}

		//ToolTip(}EX𓖂Ẵqg)ǉ܂B
		private void AddToolTip()
		{
			System.Windows.Forms.ToolTip tipMailFrom = new System.Windows.Forms.ToolTip();
			tipMailFrom.SetToolTip(this.txtMailFrom, "M̃[AhXݒ肵܂B");

			System.Windows.Forms.ToolTip tipMailTo = new System.Windows.Forms.ToolTip();
			tipMailTo.SetToolTip(this.txtMailTo, "M̃[AhXݒ肵܂\nw肷ꍇ̓Z~R(;)ŋ؂܂B");

			System.Windows.Forms.ToolTip tipMailCc = new System.Windows.Forms.ToolTip();
			tipMailCc.SetToolTip(this.txtMailCc, "M(CC)̃[AhXݒ肵܂\nw肷ꍇ̓Z~R(;)ŋ؂܂B");

			System.Windows.Forms.ToolTip tipMailSmtp = new System.Windows.Forms.ToolTip();
			tipMailSmtp.SetToolTip(this.txtMailSmtp, "MSMTPT[o̖OIPAhXݒ肵܂B");

			System.Windows.Forms.ToolTip tipMailTitle = new System.Windows.Forms.ToolTip();
			tipMailTitle.SetToolTip(this.txtMailTitle, "[̃^Cgݒ肵܂B\n󔒂̏ꍇ[M]ƓYtt@Cݒ肳܂B");

			System.Windows.Forms.ToolTip tipMailText = new System.Windows.Forms.ToolTip();
			tipMailText.SetToolTip(this.txtMailText, "[̖{ݒ肵܂B");

			System.Windows.Forms.ToolTip tipChkMailExe = new System.Windows.Forms.ToolTip();
			tipChkMailExe.SetToolTip(this.chkMailExecute, "Yf[^݂ꍇA[ɂĒʒm܂B");

			System.Windows.Forms.ToolTip tipTextSqlSync = new System.Windows.Forms.ToolTip();
			tipTextSqlSync.SetToolTip(this.txtSync, "SQLo͂tH_ASQL݂tH_ɓ܂B");


			System.Windows.Forms.ToolTip tipDirSql = new System.Windows.Forms.ToolTip();
			tipDirSql.SetToolTip(this.txtDirSql, "`FbNSQLۑĂtH_w肵܂B\ngqusqlṽt@Cs܂");

			System.Windows.Forms.ToolTip tipDirResult = new System.Windows.Forms.ToolTip();
			tipDirResult.SetToolTip(this.txtDirResult, "SQL̎sʂۑtH_w肵܂B\nʂSQL{^CX^vCSV`ŕۑ܂B");

			System.Windows.Forms.ToolTip tipUser = new System.Windows.Forms.ToolTip();
			tipUser.SetToolTip(this.txtUser, "ڑOraclẽ[Uݒ肵܂B");

			System.Windows.Forms.ToolTip tipPassword = new System.Windows.Forms.ToolTip();
			tipPassword.SetToolTip(this.txtPassword, "ڑOraclẽpX[hݒ肵܂B");

			System.Windows.Forms.ToolTip tipServiceName = new System.Windows.Forms.ToolTip();
			tipServiceName.SetToolTip(this.txtServiceName, "ڑOraclẽT[rX(TNSNAMES.ORA)ݒ肵܂B");

			System.Windows.Forms.ToolTip tipExecSql = new System.Windows.Forms.ToolTip();
			tipExecSql.SetToolTip(this.btnExecSql, "SQLɂ`FbNs܂B\nYf[^݂ꍇ̓[Ƀf[^Ytđt܂B");

			System.Windows.Forms.ToolTip tipClose = new System.Windows.Forms.ToolTip();
			tipClose.SetToolTip(this.btnClose, "AvP[VI܂B\n(݉ʂɕ\Ă͕ۑ܂B)");

			//SQL Server ToolTip
			System.Windows.Forms.ToolTip tipUserSS = new System.Windows.Forms.ToolTip();
			tipUserSS.SetToolTip(this.txtUserSS, "ڑSQLServer̃[Uݒ肵܂B");

			System.Windows.Forms.ToolTip tipPasswordSS = new System.Windows.Forms.ToolTip();
			tipPasswordSS.SetToolTip(this.txtPasswordSS, "ڑSQLServer̃pX[hݒ肵܂B");

			System.Windows.Forms.ToolTip tipServerSS = new System.Windows.Forms.ToolTip();
			tipServerSS.SetToolTip(this.txtServerSS, "ڑSQLServer̃T[o (local) ݒ肵܂B");

			System.Windows.Forms.ToolTip tipDatabaseSS = new System.Windows.Forms.ToolTip();
			tipDatabaseSS.SetToolTip(this.txtDatabaseSS, "ڑSQLServer̃f[^x[X pubs ݒ肵܂B");

			//ODBC ToolTip
			System.Windows.Forms.ToolTip tipUserOdbc = new System.Windows.Forms.ToolTip();
			tipUserOdbc.SetToolTip(this.txtUserOdbc, "ڑODBC̃[Uݒ肵܂B");

			System.Windows.Forms.ToolTip tipPasswordOdbc = new System.Windows.Forms.ToolTip();
			tipPasswordOdbc.SetToolTip(this.txtPasswordOdbc, "ڑODBC̃pX[hݒ肵܂B");

			System.Windows.Forms.ToolTip tipOdbcDsn = new System.Windows.Forms.ToolTip();
			tipOdbcDsn.SetToolTip(this.txtOdbcDsn, "ڑODBCDSN(f[^\[X)ݒ肵܂B");

			//JET ToolTip
			System.Windows.Forms.ToolTip tipJet = new System.Windows.Forms.ToolTip();
			tipJet.SetToolTip(this.txtMdbPath, "ڑMDB̃t@C̏ꏊtpXɂĐݒ肵܂B");

		}

		//OȈAexetH_CONFIG.TXTǂݍ݂܂B
		public void ReadConfigFile()
		{
			//ݒt@C̓ǂݏo
			String CONFIG_TXT = Application.StartupPath + "\\" + m_config_text_name;
		
			try 
			{
				//t@C݂Γǎs
				if (File.Exists(CONFIG_TXT))
				{
					StreamReader sr = new StreamReader(CONFIG_TXT);


					//^u
					this.tabConnect.SelectedIndex = int.Parse(sr.ReadLine().Trim());

					//Directory
					this.txtDirSql.Text = sr.ReadLine().Trim();
					this.txtDirResult.Text = sr.ReadLine().Trim();
					this.chkSync.Checked = Boolean.Parse(sr.ReadLine().Trim());
					this.txtSync.Text = sr.ReadLine().Trim();

					this.chkSelectOnly.Checked = Boolean.Parse(sr.ReadLine().Trim());

					//Oracle
					this.txtUser.Text = sr.ReadLine().Trim();
					this.txtPassword.Text = sr.ReadLine().Trim();
					this.txtServiceName.Text = sr.ReadLine().Trim();
					

					//SQL SERVE
					this.txtUserSS.Text = sr.ReadLine().Trim();
					this.txtPasswordSS.Text = sr.ReadLine().Trim();
					this.txtServerSS.Text = sr.ReadLine().Trim();
					this.txtDatabaseSS.Text = sr.ReadLine().Trim();
					
					//ODBC
					this.txtUserOdbc.Text = sr.ReadLine().Trim();
					this.txtPasswordOdbc.Text = sr.ReadLine().Trim();
					this.txtOdbcDsn.Text = sr.ReadLine().Trim();
					
					//MS-Access(JET)
					this.txtMdbPath.Text = sr.ReadLine().Trim();

					//Mail
					this.chkMailExecute.Checked = Boolean.Parse(sr.ReadLine().Trim());
					this.txtMailFrom.Text = sr.ReadLine().Trim();
					this.txtMailTo.Text = sr.ReadLine().Trim();
					this.txtMailCc.Text = sr.ReadLine().Trim();
					this.txtMailSmtp.Text = sr.ReadLine().Trim();

					this.txtMailTitle.Text = sr.ReadLine().Trim();
					this.txtMailText.Text = sr.ReadToEnd();

					sr.Close();
				}
			}
			catch (IOException ioe)
			{
				MessageBox.Show("ݒۑt@Cu" + CONFIG_TXT + "v̓ǂݍ݂ɂăG[܂B\nJԂG[oꍇexeƓꏊɂCONFIG.TXT폜ĂB\n"
					+ ioe.Message,"mF",MessageBoxButtons.OK,MessageBoxIcon.Warning );
			}
		}

		//tH[IɁAexeƓꏊCONFIG.TXTƂO̐ݒt@C㏑ۑ܂B
		private void frmMain_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			//ʂ\Ă鎞(CONFIG.TXTp[^̎)ۑ
			if (m_config_text_name.ToUpper() == "CONFIG.TXT") 
			{
				//ݒt@C̏ݏ
				String CONFIG_TXT = Application.StartupPath + "\\CONFIG.TXT";
		
				try 
				{

					System.IO.StreamWriter sw = new System.IO.StreamWriter(CONFIG_TXT,false);

					//^u
					sw.WriteLine(this.tabConnect.SelectedIndex);

					//Directory
					sw.WriteLine(this.txtDirSql.Text);
					sw.WriteLine(this.txtDirResult.Text);
					sw.WriteLine(this.chkSync.Checked.ToString());
					sw.WriteLine(this.txtSync.Text);

					sw.WriteLine(this.chkSelectOnly.Checked.ToString());

					//Oracle
					sw.WriteLine(this.txtUser.Text);
					sw.WriteLine(this.txtPassword.Text);
					sw.WriteLine(this.txtServiceName.Text);

					//SQL SERVE
					sw.WriteLine(this.txtUserSS.Text);
					sw.WriteLine(this.txtPasswordSS.Text);
					sw.WriteLine(this.txtServerSS.Text);
					sw.WriteLine(this.txtDatabaseSS.Text);

					//ODBC
					sw.WriteLine(this.txtUserOdbc.Text);
					sw.WriteLine(this.txtPasswordOdbc.Text);
					sw.WriteLine(this.txtOdbcDsn.Text);
					
					//MS-Access(JET)
					sw.WriteLine(this.txtMdbPath.Text);

					//Mail
					sw.WriteLine(this.chkMailExecute.Checked.ToString());
					sw.WriteLine(this.txtMailFrom.Text);
					sw.WriteLine(this.txtMailTo.Text); 
					sw.WriteLine(this.txtMailCc.Text); 
					sw.WriteLine(this.txtMailSmtp.Text);

					sw.WriteLine(this.txtMailTitle.Text);
					sw.WriteLine(this.txtMailText.Text);



					sw.Close();
				}
				catch (IOException ioe)
				{
					MessageBox.Show("ݒۑt@Cu" + CONFIG_TXT + "v݂̏ɂăG[܂B\n"
						+ ioe.Message,"mF",MessageBoxButtons.OK,MessageBoxIcon.Warning );
				}
			}

		}

		private void timRepeatExecute_Tick(object sender, System.EventArgs e)
		{
			MessageBox.Show("TimerTest");
		}

		private void lnkHomePage_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			//NɈړƂɂ
			lnkHomePage.LinkVisited = true;
			//uEUŊJ
			System.Diagnostics.Process.Start("http://sourceforge.jp/projects/dataunit/");
		}

		private void lnkManual_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			//NɈړƂɂ
			lnkManual.LinkVisited = true;
			//uEUŊJ
			System.Diagnostics.Process.Start("http://www.geocities.jp/data_unit/index.html");

		}

		private void chkMailExecute_CheckedChanged(object sender, System.EventArgs e)
		{
			ChangeMailEnable();
		}

		private void ChangeMailEnable()
		{
			if (this.chkMailExecute.Checked == true)
			{
				this.grpMail.Enabled = true;
			}
			else
			{
				this.grpMail.Enabled = false;
			}

		}
		

		private void chkSync_CheckedChanged(object sender, System.EventArgs e)
		{
			ControllCheckBox(this.chkSync.Checked);
		}

		private void ControllCheckBox(Boolean check)
		{
			if(check == true)
			{
				this.txtDirResult.Enabled = false;
				this.txtSync.Enabled = true;
				this.btnDirResult.Enabled = false;
				this.txtDirResult.Text = this.txtDirSql.Text + "\\" + this.txtSync.Text;
			}
			else if(check == false)
			{
				this.txtDirResult.Enabled = true;
				this.txtSync.Enabled = false;
				this.btnDirResult.Enabled = true;
			}
		}

		private void txtSync_TextChanged(object sender, System.EventArgs e)
		{
			this.txtDirResult.Text = this.txtDirSql.Text + "\\" +this.txtSync.Text;
		}

		private void btnExpSql_Click(object sender, System.EventArgs e)
		{
			callExplorerExe(this.txtDirSql.Text);
		}

		private void btnExpResult_Click(object sender, System.EventArgs e)
		{
			callExplorerExe(this.txtDirResult.Text);
		}


		private void callExplorerExe(string path)
		{
			string program = @"explorer.exe";
			string argument = @"/e," + path;

			Process extProcess = new Process();
			extProcess.StartInfo.FileName = program;	//Nt@C(explorer.exe)
			extProcess.StartInfo.Arguments = argument;	//N̈(/e, c:\)
			extProcess.Start();	
		}

		private void btnDirMdb_Click(object sender, System.EventArgs e)
		{
			this.ofdDir.InitialDirectory  = this.txtMdbPath.Text ;
			this.ofdDir.Filter = "MDBt@C(*.mdb) | *.mdb";
			this.ofdDir.ShowDialog();
		}

		private void ofdDir_FileOk(object sender, System.ComponentModel.CancelEventArgs e)
		{
			this.txtMdbPath.Text = ofdDir.FileName;
		}

		private void txtDirSql_TextChanged(object sender, System.EventArgs e)
		{
			if(Directory.Exists(txtDirSql.Text) == true) 
			{
				this.btnExpSql.Enabled = true;
				this.btnExecSql.Enabled = true;
			}
			else
			{
				this.btnExpSql.Enabled = false;
				this.btnExecSql.Enabled = false;
			}
			this.txtDirResult.Text = this.txtDirSql.Text + "\\" +this.txtSync.Text;
		}

		private void txtDirResult_TextChanged(object sender, System.EventArgs e)
		{
			if(Directory.Exists(txtDirResult.Text) == true) 
			{
				this.btnExpResult.Enabled = true;
			}
			else
			{
				this.btnExpResult.Enabled = false;
			}
		}





	}
}
