﻿using System;
using System.Collections.Generic;
using System.Text;
using Con = System.Console;
using DataUnit.Core;
using System.Reflection;
using System.IO;

namespace DataUnit.Console
{
    class Program
    {
        static void Main(string[] args)
        {
            WriteVersion();
            if (args.Length != 1 ){
                WriteParamError();
                return;
            }

            string configPath = GetConfigPath(args[0]);
            if (!File.Exists(configPath))
            {
                WriteParamError();
                return;
            }

            Host host = new Host(configPath);
            try
            {
                host.ReadConfig();
                
                Con.WriteLine("「{0}」フォルダのSQLを実行します。", host.Config.SqlPath);
                host.Status += new Host.StatusEventHandler(host_Status);
                host.CheckData();
            }
            catch (Exception ex)
            {
                WriteException(ex);
            }

        }

        private static string GetConfigPath(string arg )
        {
            string result = "";
            if (Path.IsPathRooted(arg))
            {
                result = arg;
            }
            else
            {
                result = Path.GetFullPath(arg);
            }
            return result;
        }

        private static void WriteException(Exception ex)
        {
            Con.WriteLine("エラーが発生しました。");
            Con.WriteLine(ex.Message);
            Con.WriteLine(ex.ToString());
            Con.WriteLine("");
        }

        private static void WriteParamError()
        {
            Con.WriteLine("引数が誤っています。");
            Con.WriteLine("設定ファイル名を正しく指定してください。");
            Con.WriteLine("　例：DataUnit.Console.exe config.xml");
            Con.WriteLine(@"　例：DataUnit.Console.exe C:\DataUnit\config.xml");
            Con.WriteLine("");
        }

        private static void WriteVersion()
        {
            Assembly mainAssembly = Assembly.GetEntryAssembly();
            AssemblyName mainAssemName = mainAssembly.GetName();
            Version ver = mainAssemName.Version;
            Con.WriteLine("*** DataUnit Ver {0}.{1}.{2} ***", ver.Major, ver.Minor, ver.Revision);
            Con.WriteLine("");
        }

        static void host_Status(object sender, StatusEventArgs e)
        {
            Con.WriteLine(e.Message);
            if (e.Kind == StatusKind.Start){
                Con.WriteLine("全{0}件のSQLを実行します。",e.AllCount.ToString());
            }
        }
    }
}

