package jp.ac.fun.db.data;

import java.util.List;
import java.util.Map;

/**
 * 一意な一行分のDBデータをするクラスです。
 * @param <T1> カラムを一意に識別する値の型
 * @param <T2> カラム値の型
 */
public interface UniqueEntity<T1, T2> {

    /**
     * 一意性情報を使用して比較対象の{@code entity}と同じデータであるとみなせるかどうかを試験します。
     * 等しい場合に{@code true}を返却します。
     * @param entity 比較対象の{@code UniqueEntity}
     * @return 等しいかどうか
     */
    public boolean same(UniqueEntity<T1, T2> entity);

    /**
     * 一意性情報を示すリストを返却します。<br>
     * PKが設定されている場合にはPKカラムの値から構成されるリストを返却します。<br>
     * PKが設定されていない場合には全カラムの値から構成されるリストを返却します。
     *
     * @return 一意性情報リスト
     */
    public List<T2> getKey();

    /**
     * 一行分のデータを取得します。
     * @return 一行分のデータ
     */
    public Map<T1, T2> getEntity();

    /**
     * テーブル名を取得します。
     * @return テーブル名
     */
    public String getTableName();
}
