<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="param.xsl"/>
  <xsl:output method="text" encoding="$output.encoding"/>


  <xsl:template name="field.constraint">
    <xsl:param name="field"/>
    <xsl:value-of select="$field/@name"/>
    <xsl:text> </xsl:text>
    <xsl:call-template name="field.type"><xsl:with-param name="field" select="$field"/></xsl:call-template>
    <xsl:if test="$field/@null!='yes'"> not</xsl:if><xsl:text> null</xsl:text>
    <xsl:if test="$field/@default"> default <xsl:call-template name="value.translace">
      <xsl:with-param name="value" select="$field/@default"/>
    </xsl:call-template></xsl:if>
  </xsl:template>


  <xsl:template name="field.type">
    <xsl:param name="field"/>
    <xsl:variable name="name" select="$field/@type"/>
    <xsl:variable name="sql-type" select="$rdbms/type-defs/type[@name=$name]"/>
    <xsl:value-of select="$sql-type/@sql-name"/>
    <xsl:if test="$sql-type[@has-length='yes']">(<xsl:value-of select="$field/@length"/>)</xsl:if>
  </xsl:template>

  <xsl:template name="field.list">
    <xsl:param name="list"/>
    <xsl:text>(</xsl:text>
    <xsl:value-of select="$list[1]"/>
    <xsl:for-each select="$list[position() > 1]">,<xsl:value-of select="current()"/></xsl:for-each>
    <xsl:text>)</xsl:text>
  </xsl:template>

  <xsl:template name="value.list">
    <xsl:param name="list"/>
    <xsl:text>(</xsl:text>
    <xsl:call-template name="value.translate"><xsl:with-param name="value" select="$list[1]"/></xsl:call-template>
    <xsl:for-each select="$list[position() > 1]">,
      <xsl:call-template name="value.translate"><xsl:with-param name="value" select="current()"/></xsl:call-template>
    </xsl:for-each>
    <xsl:text>)</xsl:text>
  </xsl:template>

  <xsl:template name="value.translate">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$rdbms/value-defs/value[@name=$value]">
        <xsl:value-of select="$rdbms/value-defs/value[@name=$value]/@sql-value"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$value"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
