<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="param.xsl"/>
  <xsl:import href="common.xsl"/>
  <xsl:import href="insert.xsl"/>
  <xsl:import href="index.xsl"/>

  <xsl:template match="/">
    <xsl:apply-templates select="//table"/>
  </xsl:template>

  <xsl:template match="table">
    <xsl:text>create table </xsl:text><xsl:value-of select="@name"/><xsl:text> (
</xsl:text>
  <!-- field constraints -->
  <xsl:text>    </xsl:text><xsl:call-template name="field.constraint"><xsl:with-param name="field" select="./field[1]"/></xsl:call-template><xsl:text>
</xsl:text>
<xsl:for-each select="./field[position() > 1]">
  <xsl:text>  , </xsl:text><xsl:call-template name="field.constraint"><xsl:with-param name="field" select="current()"/></xsl:call-template><xsl:text>
</xsl:text>
</xsl:for-each>
  <!-- primary key -->
  <xsl:apply-templates select="primary-key"/>
  <xsl:apply-templates select="foreign-key"/>
  <xsl:text>);
</xsl:text>
  <xsl:if test="$createtable.insert='yes'">
    <xsl:apply-templates select="insert"/>
  </xsl:if>
  <xsl:if test="$createtable.createindex='yes'">
    <xsl:apply-templates select="index"/>
  </xsl:if>
  <xsl:text>

</xsl:text>
  </xsl:template>


  <xsl:template match="primary-key">
    <xsl:text>  , primary key </xsl:text><xsl:call-template name="field.list"><xsl:with-param name="list" select="field/@name"/></xsl:call-template><xsl:text>
</xsl:text>
  </xsl:template>

  <xsl:template match="foreign-key">
    <xsl:text>  , foreign key </xsl:text>
    <xsl:call-template name="field.list"><xsl:with-param name="list" select="field/@name"/></xsl:call-template>
    <xsl:text> references </xsl:text><xsl:value-of select="@ref"/><xsl:text>(</xsl:text>
    <xsl:choose>
      <xsl:when test="field[1]/@ref"><xsl:value-of select="field[1]/@ref"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="field[1]/@name"/></xsl:otherwise>
    </xsl:choose>
    <xsl:for-each select="field[position() > 1]">
      <xsl:text>,</xsl:text>
      <xsl:choose>
        <xsl:when test="field[1]/@ref"><xsl:value-of select="field[1]/@ref"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="field[1]/@name"/></xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
    <xsl:text>)
</xsl:text>
  </xsl:template>


</xsl:stylesheet>

