<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="param.xsl"/>
  <xsl:import href="common.xsl"/>
  <xsl:import href="../common/index.xsl"/>

  <xsl:template match="/database">
    <xsl:for-each select=".//table">
      <xsl:for-each select="index">
drop index 
        <xsl:call-template name="index.name">
          <xsl:with-param name="node" select="current()"/>
        </xsl:call-template>;
      </xsl:for-each>
    </xsl:for-each>

    <xsl:call-template name="table.drop">
      <xsl:with-param name="nodes" select=".//table"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="table.drop">
    <xsl:param name="nodes"/>
    <xsl:if test="count($nodes) > 1">
      <xsl:call-template name="table.drop">
        <xsl:with-param name="nodes" select="$nodes[position() > 1]"/>
      </xsl:call-template>
    </xsl:if>
drop table <xsl:value-of select="$nodes[position() = 1]/@name"/>;
  </xsl:template>
</xsl:stylesheet>
