<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="param.xsl"/>
  <xsl:import href="common.xsl"/>

  <xsl:template match="/">
    <xsl:apply-templates select="//insert"/>
  </xsl:template>

  <xsl:template match="insert">
    <xsl:variable name="into">
      <xsl:choose>
        <xsl:when test="boolean(@into)"><xsl:value-of select="@into"/></xsl:when>
        <xsl:when test="boolean(../@name)"><xsl:value-of select="../@name"/></xsl:when>
        <xsl:otherwise>---
        <xsl:message>No table given.</xsl:message>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:for-each select="values">
      <xsl:text>insert into </xsl:text><xsl:text> </xsl:text><xsl:value-of select="$into"/><xsl:text> </xsl:text>
      <xsl:if test="../fields">
        <xsl:call-template name="field.list"><xsl:with-param name="list" select="../fields/field/@name"/></xsl:call-template>
        <xsl:text> </xsl:text>
      </xsl:if>
      <xsl:text>values</xsl:text>
      <xsl:call-template name="value.list">
        <xsl:with-param name="list" select="entry/@value"/>
      </xsl:call-template>
    <xsl:text>;
</xsl:text>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
