<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="param.xsl"/>
  <xsl:import href="../common/field.xsl"/>
  <xsl:import href="../common/index.xsl"/>

  <xsl:output method="xml" indent="no" encoding="utf-8"
    doctype-public="-//OASIS//DTD DocBook XML V4.2//EN"
    doctype-system="docbook/dtd/xml/4.2/docbookx.dtd"/>

  <xsl:variable name="msg" select="document('msg.xml')/msg/catalogue[@lang=$locale.lang]"/>

  <xsl:template match="/database">
    <article>

      <articleinfo>
        <publisher><publishername><xsl:value-of select="authorize/copyright"/></publishername></publisher>
        <pubdate><xsl:value-of select="autorize/date"/></pubdate>
        <title><xsl:value-of select="@title"/></title>
        <titleabbrev><xsl:value-of select="@name"/></titleabbrev>
        <abstract>
          <para>
            <xsl:value-of select="abstract"/>
          </para>
        </abstract>
      </articleinfo>


      <xsl:apply-templates select=".//table"/>
    </article>
  </xsl:template>

  <xsl:template match="table">
    <sect1>
      <title><xsl:value-of select="@name"/></title>
      <xsl:apply-templates select="remark"/>

      <table>
        <title><xsl:value-of select="@desc"/><xsl:value-of select="@description"/></title>
        <tgroup cols="5">
          <colspec colnum="1" colname="col1" colwidth="*"/>
          <colspec colnum="2" colname="col2" colwidth="10em"/>
          <colspec colnum="3" colname="col3" colwidth="3em"/>
          <colspec colnum="4" colname="col4" colwidth="4em"/>
          <colspec colnum="5" colname="col5" colwidth="*"/>
          <thead>
            <row>
              <entry><xsl:value-of select="$msg/table-layout/name"/></entry>
              <entry><xsl:value-of select="$msg/table-layout/type"/></entry>
              <entry><xsl:value-of select="$msg/table-layout/null"/></entry>
              <entry><xsl:value-of select="$msg/table-layout/primary-key"/></entry>
              <entry><xsl:value-of select="$msg/table-layout/description"/></entry>
            </row>
          </thead>
          <tbody>
            <xsl:for-each select="field">
              <xsl:variable name="field-name" select="@name"/>
              <row>
                <entry><xsl:value-of select="@name"/></entry>
                <entry>
                  <xsl:call-template name="field.printable-type">
                    <xsl:with-param name="node" select="current()"/>
                  </xsl:call-template>
                </entry>
                <entry>
                  <xsl:if test="@null='yes'">
                    <xsl:value-of select="$msg/table-layout/allow"/>
                  </xsl:if>
                </entry>
                <entry>
                  <xsl:for-each select="../primary-key/field">
                    <xsl:if test="@name=$field-name">PK<xsl:value-of select="position()"/></xsl:if>
                  </xsl:for-each>
                </entry>
                <entry>
                  <xsl:value-of select="@desc"/><xsl:value-of select="@description"/>
                </entry>
              </row>
            </xsl:for-each>
          </tbody>
        </tgroup>
      </table>

      <xsl:if test="foreign-key">
        <sect2>
          <title><xsl:value-of select="$msg/table-layout/foreign-key/title"/></title>
          <table>
            <tgroup cols="5">
              <colspec colnum="1" colname="col1" colwidth="*"/>
              <colspec colnum="2" colname="col2" colwidth="6em"/>
              <colspec colnum="3" colname="col3" colwidth="6em"/>
              <colspec colnum="4" colname="col4" colwidth="*"/>
              <colspec colnum="5" colname="col5" colwidth="*"/>
              <thead>
                <row>
                  <entry><xsl:value-of select="$msg/table-layout/foreign-key/ref-table"/></entry>
                  <entry><xsl:value-of select="$msg/table-layout/foreign-key/on-delete"/></entry>
                  <entry><xsl:value-of select="$msg/table-layout/foreign-key/on-update"/></entry>
                  <entry><xsl:value-of select="$msg/table-layout/foreign-key/field-name"/></entry>
                  <entry><xsl:value-of select="$msg/table-layout/foreign-key/ref-field"/></entry>
                </row>
              </thead>
              <tbody>
                <xsl:for-each select="foreign-key">
                  <xsl:variable name="fields" select="count(field) - 1"/>
                  <row>
                    <entry morerows="{$fields}"><xsl:value-of select="@ref"/></entry>
                    <entry morerows="{$fields}"><xsl:value-of select="@on-update"/></entry>
                    <entry morerows="{$fields}"><xsl:value-of select="@on-delete"/></entry>
                    <entry><xsl:value-of select="field[1]/@name"/></entry>
                    <entry>
                      <xsl:choose>
                        <xsl:when test="field[1]/@ref"><xsl:value-of select="field[1]/@ref"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="field[1]/@name"/></xsl:otherwise>
                      </xsl:choose>
                    </entry>
                  </row>
                  <xsl:for-each select="field[position() > 1]">
                    <row>
                      <entry><xsl:value-of select="@name"/></entry>
                      <entry>
                        <xsl:choose>
                          <xsl:when test="@ref"><xsl:value-of select="@ref"/></xsl:when>
                          <xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
                        </xsl:choose>
                      </entry>
                    </row>
                  </xsl:for-each>
                </xsl:for-each>
              </tbody>
            </tgroup>
          </table>
        </sect2>
      </xsl:if>
    </sect1>
  </xsl:template>

  <xsl:template match="remark">
    <abstract>
      <xsl:value-of select='normalize-space(text())'/>
    </abstract>
  </xsl:template>
</xsl:stylesheet>
