<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="param.xsl"/>
  <xsl:import href="common.xsl"/>
  <xsl:import href="../common/index.xsl"/>

  <xsl:template match="/">
    <xsl:apply-templates select="//index"/>
  </xsl:template>

  <xsl:template match="index">
    <xsl:text>create </xsl:text>
    <xsl:if test="@unique = 'yes'">
      <xsl:text>unique </xsl:text>
    </xsl:if>
    <xsl:text>index </xsl:text>
    <xsl:call-template name="index.name">
      <xsl:with-param name="node" select="current()"/>
    </xsl:call-template>
    <xsl:text> on </xsl:text>
    <xsl:choose>
      <xsl:when test="@table"><xsl:value-of select="@table"/></xsl:when>
      <xsl:when test="../@name"><xsl:value-of select="../@name"/></xsl:when>
      <xsl:otherwise>---<xsl:message>No table given.</xsl:message></xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>
    <xsl:call-template name="field.list"><xsl:with-param name="list" select="field/@name"/></xsl:call-template>
    <xsl:text>;
</xsl:text>
  </xsl:template>

</xsl:stylesheet>
