<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="param.xsl"/>
  <xsl:import href="../common/field.xsl"/>
  <xsl:import href="../common/index.xsl"/>

  <xsl:variable name="msg" select="document('msg.xml')/msg/catalogue[@lang=$locale.lang]"/>

  <xsl:output method="xml" indent="no" encoding="utf-8"
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>

  <xsl:template match="/">
    <html lang="{$locale.lang}">
      <head>
        <meta http-equiv="Content-Style-Type" content="text/css"/>
        <meta http-equiv="Content-Script-Type" content="application/x-javascript"/>
        <meta http-equiv="Content-Type" content="text/xhtml; charset=utf-8"/>
        <meta name="description" content="@title"/>
        <!-- link rel="SHORTCUT ICON" href="images/favicon.ico"/ -->
        <!-- link rev="MADE" href="mailto:{$site-config/author/@mail}"/ -->
        <link type="text/css" rel="stylesheet" href="{$url.css}" media="screen"/>
        <title><xsl:value-of select="database/@title"/></title>
      </head>
      <body>
        <div class="titlepage">
          <h1><xsl:value-of select="database/@title"/></h1>
          <xsl:apply-templates select="database/authorize"/>
          <div class="abstract">
            <xsl:value-of select="abstract"/>
          </div>
        </div>

        <xsl:call-template name="tocpage"/>

        <hr />
        <h2><a name="object-list"><xsl:value-of select="$msg/toc/object-list/title"/></a></h2>

        <xsl:if test="database/table">
          <h4><xsl:value-of select="$msg/toc/object-list/title"/></h4>
          <table class="table-list">
            <xsl:call-template name="object-list.header"/>
            <xsl:for-each select="database/table">
              <tr>
                <td><a href="#{generate-id()}"><xsl:value-of select="@name"/></a></td>
                <td><xsl:value-of select="@desc"/><xsl:value-of select="@description"/></td>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:if>

        <xsl:if test="database//index">
          <h4><xsl:value-of select="$msg/toc/object-list/index"/></h4>
          <table class="index-list">
            <xsl:call-template name="object-list.header"/>
            <xsl:for-each select="database//index">
              <tr>
                <td><a href="#{generate-id()}"><xsl:call-template name="index.name"/></a></td>
                <td><xsl:value-of select="@decs"/><xsl:value-of select="@description"/></td>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:if>

        <xsl:if test="database/sequence">
          <h4><xsl:value-of select="$msg/toc/object-list/sequence"/></h4>
          <table class="sequence-list">
            <xsl:call-template name="object-list.header"/>
            <xsl:for-each select="database/sequence">
              <tr>
                <td><a href="#{generate-id()}"><xsl:value-of select="@name"/></a></td>
                <td><xsl:value-of select="@desc"/><xsl:value-of select="@description"/></td>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:if>

        <xsl:for-each select="database/table">
          <xsl:call-template name="table-layout"/>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="database/authorize">
    <div class="author">
      Copyright (c) <xsl:value-of select="date"/>, <xsl:value-of select="copyright"/>
    </div>
  </xsl:template>

  <xsl:template name="tocpage">
    <div class="toc">
      <dl>
        <dt><xsl:value-of select="$msg/toc/title"/></dt>
        <dd>
          <dl>
            <dt><a href="#object-list"><xsl:value-of select="$msg/toc/object-list/title"/></a></dt>
            <xsl:for-each select="database/table">
              <dt><a href="#{generate-id()}"><xsl:value-of select="@name"/></a></dt>
            </xsl:for-each>
          </dl>
        </dd>
      </dl>
    </div>
  </xsl:template>

  <xsl:template name="object-list.header">
    <tr>
      <th><xsl:value-of select="$msg/toc/object-list/name"/></th>
      <th><xsl:value-of select="$msg/toc/object-list/description"/></th>
    </tr>
  </xsl:template>

  <xsl:template name="table-layout">
    <xsl:variable name="tablename" select="@name"/>
    <hr />
    <div class="table-layout">
      <div class="titlepage">
        <h2><a name="{generate-id()}"><xsl:value-of select="$tablename"/></a></h2>
        <p><xsl:apply-templates select="remark"/></p>
      </div>
      <table class="table-layout">
        <tr>
          <th><xsl:value-of select="$msg/table-layout/field/name"/></th>
          <th><xsl:value-of select="$msg/table-layout/field/type"/></th>
          <th><xsl:value-of select="$msg/table-layout/field/null"/></th>
          <th><xsl:value-of select="$msg/table-layout/field/primary-key"/></th>
          <th><xsl:value-of select="$msg/table-layout/field/description"/></th>
        </tr>
        <xsl:variable name="primary-keys" select="primary-key"/>
        <xsl:variable name="indexes" select="index"/>
        <xsl:for-each select="field">
          <xsl:variable name="field-name" select="@name"/>
          <tr>
            <td><xsl:value-of select="@name"/></td>
            <td>
              <xsl:call-template name="field.printable-type">
                <xsl:with-param name="node" select='current()'/>
              </xsl:call-template>
            </td>
            <td>
              <xsl:if test="@null='yes'"><xsl:value-of select="$msg/table-layout/field/allow"/></xsl:if>
            </td>
            <td>
              <xsl:for-each select="$primary-keys/field">
                <xsl:if test="@name=$field-name">PK<xsl:value-of select="position()"/></xsl:if>
              </xsl:for-each>
            </td>
            <td>
              <xsl:value-of select="@desc"/>
              <xsl:value-of select="@description"/>
              <xsl:apply-templates select="value-list"/>
            </td>
          </tr>
        </xsl:for-each>
      </table>
      <xsl:if test="foreign-key">
        <h5><xsl:value-of select="$msg/table-layout/foreign-key/title"/></h5>
        <table class="foreign-key">
          <tr>
            <th><xsl:value-of select="$msg/table-layout/foreign-key/refernces"/></th>
            <th><xsl:value-of select="$msg/table-layout/foreign-key/on-delete"/></th>
            <th><xsl:value-of select="$msg/table-layout/foreign-key/on-update"/></th>
            <th></th>
            <th></th>
          </tr>
          <xsl:for-each select="foreign-key">
            <xsl:variable name="fields" select="count(field)"/>
            <tr>
              <td rowspan="{$fields}"><xsl:value-of select="@ref"/></td>
              <td rowspan="{$fields}"><xsl:value-of select="@on-delete"/></td>
              <td rowspan="{$fields}"><xsl:value-of select="@on-update"/></td>
              <td><xsl:value-of select="field[1]/@name"/></td>
              <td><xsl:value-of select="field[1]/@ref"/></td>
            </tr>
            <xsl:for-each select="field[position() > 1]">
              <tr>
                <td><xsl:value-of select="@name"/></td>
                <td><xsl:value-of select="@ref"/></td>
              </tr>
            </xsl:for-each>
          </xsl:for-each>
        </table>
      </xsl:if>

      <xsl:if test="(index|/database/index[@ref=$tablename])">
        <h5><xsl:value-of select="$msg/table-layout/index/title"/></h5>
        <table class="indexes">
          <tr>
            <th><xsl:value-of select="$msg/table-layout/index/name"/></th>
            <th><xsl:value-of select="$msg/table-layout/index/unique"/></th>
            <th><xsl:value-of select="$msg/table-layout/index/description"/></th>
            <th></th>
          </tr>
          <xsl:for-each select="(index|/database/index[@ref=$tablename])">
            <xsl:variable name="fields" select="count(field)"/>
            <tr>
              <td rowspan="{$fields}">
                <xsl:call-template name="index.name">
                  <xsl:with-param name="node" select="current()"/>
                </xsl:call-template>
              </td>
              <td rowspan="{$fields}">
                <xsl:if test="@unique = 'yes'">
                  <xsl:value-of select="$msg/table-layout/index/yes"/>
                </xsl:if>
              </td>
              <td rowspan="{$fields}"><xsl:value-of select="@desc"/><xsl:value-of select="@description"/></td>
              <td>
                <xsl:value-of select="field[1]/@name"/>
              </td>
            </tr>
            <xsl:for-each select="field[position() > 1]">
              <tr><td><xsl:value-of select="@name"/></td></tr>
            </xsl:for-each>
          </xsl:for-each>
        </table>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template match="table/field/value-list">
    <dl>
      <xsl:for-each select="where">
        <dt><xsl:value-of select="@value"/></dt>
        <dd><p><xsl:apply-templates /></p></dd>
      </xsl:for-each>
    </dl>
  </xsl:template>

</xsl:stylesheet>
