/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.excel;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.yher2.commons.io.Classpath;
import net.yher2.commons.lang.DateUtils;
import net.yher2.junit.db.data.ColumnData;
import net.yher2.junit.db.data.Header;
import net.yher2.junit.db.data.Row;
import net.yher2.junit.db.data.Table;
import net.yher2.junit.db.excel.ExcelReader;

public class ExcelReaderTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRead() throws IOException {
        ExcelReader reader = new ExcelReader(new Classpath("net/yher2/junit/db/excel/ExcelReaderTestNormal.xls"));
        Table[] table = reader.read();
        Assert.assertEquals((int)1, (int)table.length);
        Assert.assertEquals((String)"WORKBOOK", (String)table[0].getName());
        Header[] header = table[0].getHeader();
        Header[] expectHeader = new Header[]{new Header("ID", true), new Header("String"), new Header("NUMBER"), new Header("BOOLEAN"), new Header("BLANK"), new Header("DATE")};
        Assert.assertEquals((int)6, (int)header.length);
        int i = 0;
        while (i < header.length) {
            Assert.assertEquals((boolean)expectHeader[i].isPrimaryKey(), (boolean)header[i].isPrimaryKey());
            Assert.assertEquals((String)expectHeader[i].getName(), (String)header[i].getName());
            ++i;
        }
        Row[] row = table[0].getRow();
        Object[][] objectArrayArray = new Object[8][];
        Object[] objectArray = new Object[6];
        objectArray[0] = new Integer(1);
        objectArray[1] = "\u65e5\u672c\u8a9e";
        objectArray[2] = new Integer(1234567890);
        objectArray[3] = new Boolean(true);
        objectArray[5] = DateUtils.parse(2004, 12, 24);
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[6];
        objectArray2[0] = new Integer(2);
        objectArray2[1] = "English";
        objectArray2[2] = new Double(123.456);
        objectArray2[3] = new Boolean(false);
        objectArray2[5] = DateUtils.parse(2004, 12, 24, 10, 20, 30);
        objectArrayArray[1] = objectArray2;
        Object[] objectArray3 = new Object[6];
        objectArray3[0] = new Integer(3);
        objectArray3[1] = "'\"/\\\uffe0\uff5e";
        objectArray3[2] = new Integer(123);
        objectArray3[3] = new Integer(1);
        objectArray3[5] = DateUtils.parse(2004, 12, 24, 10, 20, 30);
        objectArrayArray[2] = objectArray3;
        Object[] objectArray4 = new Object[6];
        objectArray4[0] = new Integer(4);
        objectArray4[3] = new Integer(0);
        objectArray4[5] = DateUtils.parse(2004, 12, 1);
        objectArrayArray[3] = objectArray4;
        Object[] objectArray5 = new Object[6];
        objectArray5[0] = new Integer(5);
        objectArray5[5] = DateUtils.parse(2004, 1, 1);
        objectArrayArray[4] = objectArray5;
        Object[] objectArray6 = new Object[6];
        objectArray6[0] = new Integer(6);
        objectArrayArray[5] = objectArray6;
        Object[] objectArray7 = new Object[6];
        objectArray7[0] = new Integer(7);
        objectArrayArray[6] = objectArray7;
        Object[] objectArray8 = new Object[6];
        objectArray8[0] = new Integer(8);
        objectArrayArray[7] = objectArray8;
        Object[][] expectRow = objectArrayArray;
        Assert.assertEquals((int)expectRow.length, (int)row.length);
        int i2 = 0;
        while (i2 < expectRow.length) {
            ColumnData[] column = row[i2].getColumn();
            Assert.assertEquals((int)expectRow[i2].length, (int)column.length);
            int j = 0;
            while (j < column.length) {
                Assert.assertEquals((Object)expectRow[i2][j], (Object)column[j].getValue());
                ++j;
            }
            ++i2;
        }
    }

    public void testReadNoColumnData() throws IOException {
        ExcelReader reader = new ExcelReader(new Classpath("net/yher2/junit/db/excel/ExcelReaderTestNoColumnData.xls"));
        Table[] table = reader.read();
        Assert.assertEquals((int)1, (int)table.length);
        Assert.assertEquals((String)"WORKBOOK", (String)table[0].getName());
        Header[] header = table[0].getHeader();
        Header[] expectHeader = new Header[]{new Header("ID", true), new Header("String"), new Header("NUMBER"), new Header("BOOLEAN"), new Header("BLANK"), new Header("DATE")};
        Assert.assertEquals((int)6, (int)header.length);
        int i = 0;
        while (i < header.length) {
            Assert.assertEquals((boolean)expectHeader[i].isPrimaryKey(), (boolean)header[i].isPrimaryKey());
            Assert.assertEquals((String)expectHeader[i].getName(), (String)header[i].getName());
            ++i;
        }
        Row[] row = table[0].getRow();
        Assert.assertEquals((int)0, (int)row.length);
    }

    public void testReadMultiTable() throws IOException {
        ExcelReader reader = new ExcelReader(new Classpath("net/yher2/junit/db/excel/ExcelReaderTestMultiTable.xls"));
        Table[] table = reader.read();
        Assert.assertEquals((int)3, (int)table.length);
        Assert.assertEquals((String)"Table1", (String)table[0].getName());
        Assert.assertEquals((String)"Table2", (String)table[1].getName());
        Assert.assertEquals((String)"Table3", (String)table[2].getName());
    }

    public void testReadNoData() throws IOException {
        ExcelReader reader = new ExcelReader(new Classpath("net/yher2/junit/db/excel/ExcelReaderTestNoData.xls"));
        try {
            Table[] table = reader.read();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail();
    }

    public void testReadNoHeaderData() throws IOException {
        ExcelReader reader = new ExcelReader(new Classpath("net/yher2/junit/db/excel/ExcelReaderTestNoHeaderData.xls"));
        try {
            Table[] table = reader.read();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail();
    }

    public void testReadIllegalNumOfCoumn() throws IOException {
        ExcelReader reader = new ExcelReader(new Classpath("net/yher2/junit/db/excel/ExcelReaderTestIllegalNumOfColumn.xls"));
        try {
            Table[] table = reader.read();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail();
    }
}

