/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.yher2.commons.io.Classpath;
import net.yher2.commons.lang.DateUtils;
import net.yher2.commons.lang.ExtendResourceBundle;
import net.yher2.junit.db.DBTestCase;
import net.yher2.junit.db.data.ColumnData;
import net.yher2.junit.db.data.Row;
import net.yher2.junit.db.data.Table;
import net.yher2.junit.db.excel.ExcelReader;
import net.yher2.junit.db.test.data.Child;
import net.yher2.junit.db.test.data.Parent;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBTestCaseTest
extends DBTestCase {
    private static Log log = LogFactory.getLog(DBTestCaseTest.class);
    private static BasicDataSource dataSource;

    static {
        try {
            DBTestCaseTest.prepareDataSource();
            DBTestCaseTest.prepareDatabase();
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize", (Throwable)e);
        }
    }

    public void testInitialize() throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("SELECT * FROM PARENT");
            rs = ps.executeQuery();
            DBTestCaseTest.assertFalse((boolean)rs.next());
            ps = con.prepareStatement("SELECT * FROM CHILD");
            rs = ps.executeQuery();
            DBTestCaseTest.assertFalse((boolean)rs.next());
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)con);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)ps);
        DbUtils.closeQuietly((Connection)con);
    }

    public void testPrepare() throws Exception {
        Classpath path = new Classpath("net/yher2/junit/db/excel/DatabaseManagerTest.xls");
        this.prepare(path);
        ExcelReader reader = new ExcelReader(path);
        Table[] table = reader.read();
        Connection con = this.getConnection();
        Row[] row = table[0].getRow();
        this.assertParent(row[0], this.getParent(con, 1));
        this.assertParent(row[1], this.getParent(con, 2));
        this.assertParent(row[2], this.getParent(con, 3));
        row = table[1].getRow();
        this.assertChild(row[0], this.getChild(con, 1));
        this.assertChild(row[1], this.getChild(con, 2));
        this.assertChild(row[2], this.getChild(con, 3));
    }

    public void testClear() throws Exception {
        Classpath path = new Classpath("net/yher2/junit/db/excel/DatabaseManagerTest.xls");
        this.prepare(path);
        this.clear(path);
        Connection con = this.getConnection();
        DBTestCaseTest.assertNull((Object)this.getParent(con, 1));
        DBTestCaseTest.assertNull((Object)this.getParent(con, 2));
        DBTestCaseTest.assertNull((Object)this.getParent(con, 3));
        DBTestCaseTest.assertNull((Object)this.getChild(con, 1));
        DBTestCaseTest.assertNull((Object)this.getChild(con, 2));
        DBTestCaseTest.assertNull((Object)this.getChild(con, 3));
    }

    private void assertParent(Row row, Parent parent) {
        ColumnData[] column = row.getColumn();
        DBTestCaseTest.assertEquals((Object)((Integer)column[0].getValue()), (Object)new Integer(parent.getParentId()));
        DBTestCaseTest.assertEquals((Object)((Integer)column[1].getValue()), (Object)new Integer(parent.getIntValue()));
        DBTestCaseTest.assertEquals((double)((Double)column[2].getValue()), (double)parent.getDoubleValue(), (double)4.0);
        DBTestCaseTest.assertEquals((Object)column[3].getValue(), (Object)parent.getVarcharValue());
        DBTestCaseTest.assertEquals((Object)column[4].getValue(), (Object)parent.getCharValue());
        log.debug(column[5].getValue());
        log.debug((Object)parent.getDateValue());
        this.assertEquals(DateUtils.toSqlDate((java.util.Date)column[5].getValue()), parent.getDateValue());
        DBTestCaseTest.assertEquals((Object)column[6].getValue(), (Object)parent.getTimestampValue());
        DBTestCaseTest.assertEquals((Object)column[7].getValue(), (Object)new Boolean(parent.isBooleanValue()));
    }

    private void assertChild(Row row, Child parent) {
        ColumnData[] column = row.getColumn();
        DBTestCaseTest.assertEquals((Object)((Integer)column[0].getValue()), (Object)new Integer(parent.getChildId()));
        DBTestCaseTest.assertEquals((Object)((Integer)column[1].getValue()), (Object)new Integer(parent.getParentId()));
        DBTestCaseTest.assertEquals((Object)((Integer)column[2].getValue()), (Object)new Integer(parent.getIntValue()));
        DBTestCaseTest.assertEquals((double)((Double)column[3].getValue()), (double)parent.getDoubleValue(), (double)4.0);
        DBTestCaseTest.assertEquals((Object)column[4].getValue(), (Object)parent.getVarcharValue());
        DBTestCaseTest.assertEquals((Object)column[5].getValue(), (Object)parent.getCharValue());
        this.assertEquals(DateUtils.toSqlDate((java.util.Date)column[6].getValue()), parent.getDateValue());
        DBTestCaseTest.assertEquals((Object)column[7].getValue(), (Object)parent.getTimestampValue());
        DBTestCaseTest.assertEquals((Object)column[8].getValue(), (Object)new Boolean(parent.isBooleanValue()));
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("DELETE FROM CHILD");
            ps.executeUpdate();
            ps = con.prepareStatement("DELETE FROM PARENT");
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)con);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)ps);
        DbUtils.closeQuietly((Connection)con);
    }

    private static void prepareDataSource() {
        ExtendResourceBundle resource = ExtendResourceBundle.getBundle("dbTestCase");
        dataSource = new BasicDataSource();
        dataSource.setDriverClassName(resource.getString("dbtest.db.driver"));
        dataSource.setUsername(resource.getString("dbtest.db.username"));
        dataSource.setPassword(resource.getString("dbtest.db.password"));
        dataSource.setUrl(resource.getString("dbtest.db.url"));
    }

    private static void prepareDatabase() throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = dataSource.getConnection();
            ps = con.prepareStatement("CREATE TABLE PARENT (\tPARENT_ID INTEGER PRIMARY KEY,\tINT_VAL INTEGER,\tDBL_VAL DOUBLE,\tVCR_VAL VARCHAR(256),\tCHR_VAL CHAR(3),\tDATE_VAL DATE,\tTIMESTAMP_VAL TIMESTAMP,\tBOOL_VAL BOOLEAN)");
            ps.execute();
            ps = con.prepareStatement("CREATE TABLE CHILD (\tCHILD_ID INTEGER PRIMARY KEY,\tPARENT_ID INTEGER,\tINT_VAL INTEGER,\tDBL_VAL DOUBLE,\tVCR_VAL VARCHAR(256),\tCHR_VAL CHAR(3),\tDATE_VAL DATE,\tTIMESTAMP_VAL TIMESTAMP,\tBOOL_VAL BOOLEAN,\tFOREIGN KEY (PARENT_ID) REFERENCES PARENT (PARENT_ID))");
            ps.execute();
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)con);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)ps);
        DbUtils.closeQuietly((Connection)con);
    }

    protected Parent getParent(Connection con, int id) throws SQLException {
        String sql = "SELECT \tPARENT_ID as parentId, \tINT_VAL as intvalue,\tDBL_VAL as doubleValue,\tVCR_VAL as varcharValue,\tCHR_VAL as charValue,\tDATE_VAL as dateValue,\tTIMESTAMP_VAL as timestampValue,\tBOOL_VAL as booleanValue FROM PARENT WHERE PARENT_ID = ?";
        QueryRunner queryRunner = new QueryRunner();
        List list = (List)queryRunner.query(con, sql, new Object[]{new Integer(id)}, (ResultSetHandler)new BeanListHandler(Parent.class));
        if (list.size() == 0) {
            return null;
        }
        return (Parent)list.get(0);
    }

    protected Child getChild(Connection con, int id) throws SQLException {
        String sql = "SELECT \tCHILD_ID childId, \tPARENT_ID parentId, \tINT_VAL intvalue,\tDBL_VAL doubleValue,\tVCR_VAL varcharValue,\tCHR_VAL charValue,\tDATE_VAL dateValue,\tTIMESTAMP_VAL timestampValue,\tBOOL_VAL booleanValue FROM Child WHERE CHILD_ID = ?";
        QueryRunner queryRunner = new QueryRunner();
        List list = (List)queryRunner.query(con, sql, new Object[]{new Integer(id)}, (ResultSetHandler)new BeanListHandler(Child.class));
        if (list.size() == 0) {
            return null;
        }
        return (Child)list.get(0);
    }

    protected Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    protected void assertEquals(Date expected, Date actual) {
        java.util.Date expected2 = DateUtils.parse(DateUtils.getYear(expected), DateUtils.getMonth(expected), DateUtils.getDay(expected));
        java.util.Date actual2 = DateUtils.parse(DateUtils.getYear(actual), DateUtils.getMonth(actual), DateUtils.getDay(actual));
        DBTestCaseTest.assertEquals((Object)expected2, (Object)actual2);
    }
}

