/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.yher2.commons.collections.CollectionUtils;
import net.yher2.junit.db.data.ColumnData;
import net.yher2.junit.db.data.Header;
import net.yher2.junit.db.data.Row;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Table {
    Log log = LogFactory.getLog(this.getClass());
    String name;
    Header[] header;
    List rowList;

    public Table(String name) {
        this.name = name;
        this.header = new Header[0];
        this.rowList = new ArrayList();
    }

    public Header[] getHeader() {
        return this.header;
    }

    public void setHeader(Header[] header) {
        this.header = header;
    }

    public void addRow(Row row) {
        this.rowList.add(row);
    }

    public Row[] getRow() {
        return this.rowList.toArray(new Row[this.rowList.size()]);
    }

    public String getName() {
        return this.name;
    }

    public void insert(Connection con) throws SQLException {
        PreparedStatement ps = null;
        String sql = "INSERT INTO " + this.getName() + "(" + this.getHeaderCsv() + ")" + " VALUES(" + this.getArgumentCsv() + ")";
        try {
            ps = con.prepareStatement(sql);
            this.log.debug((Object)sql);
            Row[] row = this.getRow();
            int i = 0;
            while (i < row.length) {
                row[i].set(ps);
                ps.executeUpdate();
                ++i;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private String getHeaderCsv() {
        if (this.header.length == 0) {
            return "";
        }
        String csv = "";
        int i = 0;
        while (i < this.header.length) {
            csv = String.valueOf(csv) + this.header[i].getName() + ",";
            ++i;
        }
        return csv.substring(0, csv.length() - 1);
    }

    private String getArgumentCsv() {
        if (this.header.length == 0) {
            return "";
        }
        String csv = "";
        int i = 0;
        while (i < this.header.length) {
            csv = String.valueOf(csv) + "?,";
            ++i;
        }
        return csv.substring(0, csv.length() - 1);
    }

    public void delete(Connection con) throws SQLException {
        String sql = "delete from " + this.getName() + " where ";
        String condition = "";
        Header[] pk = this.getPrimaryKey();
        if (pk.length == 0) {
            throw new IllegalStateException(String.valueOf(this.getName()) + ": There is no primary key header.");
        }
        int i = 0;
        while (i < pk.length) {
            condition = String.valueOf(condition) + pk[i].getName() + "=? and ";
            ++i;
        }
        sql = String.valueOf(sql) + condition.substring(0, condition.length() - 4);
        Statement ps = null;
        try {
            this.log.debug((Object)sql);
            ps = con.prepareStatement(sql);
            int[] pkIndex = this.getPrimaryKeyIndex();
            Row[] row = this.getRow();
            int i2 = row.length - 1;
            while (i2 >= 0) {
                ColumnData[] column = row[i2].getColumn();
                ArrayList<String> list = new ArrayList<String>();
                int j = 0;
                while (j < pkIndex.length) {
                    column[pkIndex[j]].set(j + 1, (PreparedStatement)ps);
                    list.add(String.valueOf(this.header[pkIndex[j]].getName()) + "=" + column[pkIndex[j]].getValue());
                    ++j;
                }
                this.log.debug((Object)("SET: " + CollectionUtils.toCsv(list)));
                ps.executeUpdate();
                --i2;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private Header[] getPrimaryKey() {
        ArrayList<Header> pkList = new ArrayList<Header>();
        int i = 0;
        while (i < this.header.length) {
            if (this.header[i].isPrimaryKey()) {
                pkList.add(this.header[i]);
            }
            ++i;
        }
        return pkList.toArray(new Header[pkList.size()]);
    }

    private int[] getPrimaryKeyIndex() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.header.length) {
            if (this.header[i].isPrimaryKey()) {
                list.add(new Integer(i));
            }
            ++i;
        }
        return ArrayUtils.toPrimitive((Integer[])list.toArray(new Integer[list.size()]));
    }
}

