package org.dbunitng.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * テストメソッド実行前のSetUp処理を指定する。
 * 
 * @author jyukutyo
 * 
 */
@Retention(RUNTIME)
@Target(METHOD)
public @interface SetUpOperation {

	/**
	 * SetUp処理において、データベースのテーブルに対して行う処理を指定する。
	 * 
	 * @return データベースのテーブルに対して行う処理方法
	 */
	DatabaseOperationType value() default DatabaseOperationType.NONE;

	/**
	 * SetUp処理において投入する初期データを記述したファイルを指定する。 pathname または extension
	 * のどちらかを指定する必要がある。
	 * 
	 * @return 初期データを記述したファイル
	 */
	String pathname() default "";

	/**
	 * ファイルの拡張子。 pathname または extension のどちらかを指定する必要がある。
	 * 
	 * @return 拡張子
	 */
	String extension() default "";

}
