package org.dbunitng.beans;

import static org.testng.Assert.*;

import java.util.Arrays;
import java.util.List;

import org.dbunitng.beans.testbeans.ArrayPropertyBean;
import org.dbunitng.beans.testbeans.MetaDataSampleBean;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups = "beans")
public class BeanMetaDataTest {

	public void testCreateProperties() {
		BeanMetaData data = new BeanMetaData(MetaDataSampleBean.class);

		assertSame(data.getTargetClass(), MetaDataSampleBean.class);

		BeanProperty stringProperty = data.getProperty("stringProperty");
		assertEquals("stringProperty", stringProperty.getName());
		assertSame(String.class, stringProperty.getType());

		BeanProperty intProperty = data.getProperty("intProperty");
		assertEquals("intProperty", intProperty.getName());
		assertSame(int.class, intProperty.getType());

		BeanProperty listProperty = data.getProperty("listProperty");
		assertEquals("listProperty", listProperty.getName());
		assertSame(List.class, listProperty.getType());

	}

	@DataProvider(name = "property-provider")
	public Object[][] propertyData() {
		return new Object[][] { { "a", 0, new String[] { "a", "aa", "aaa" } },
			{ null, 1, new String[] { "b" } }, { "c", 0, new String[0] },
			{ "d", -1, null } };
	}

	@Test(dataProvider = "property-provider")
	public void testGetValue(String s, int i, String[] array) {

		MetaDataSampleBean bean = new MetaDataSampleBean();
		bean.setStringProperty(s);
		bean.setIntProperty(i);
		bean.setListProperty(array == null ? null : Arrays.asList(array));

		BeanMetaData data = new BeanMetaData(MetaDataSampleBean.class);

		assertEquals(data.getProperty("stringProperty").getValue(bean), s);
		assertEquals(data.getProperty("intProperty").getValue(bean), i);
		assertEquals(
			data.getProperty("listProperty").getValue(bean),
			array == null ? null : Arrays.asList(array));
	}

	public void testGetArrayValue() {

		ArrayPropertyBean bean = new ArrayPropertyBean();
		String[] array = new String[] { "a", "", null };
		bean.setArray(array);
		int[] is = new int[] { 0, 1, 2 };
		bean.publicArray = is;

		BeanMetaData data = new BeanMetaData(ArrayPropertyBean.class);

		assertEquals(data.getProperty("array").getValue(bean), array);
		assertEquals(data.getProperty("publicArray").getValue(bean), is);
	}

}
