package org.dbunitng.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * データベースへの接続情報などテストスイート全体での設定を表す。
 * 
 * @author jyukutyo
 * 
 */
@Retention(RUNTIME)
@Target(METHOD)
public @interface DbUnitNG {

	/**
	 * JDBCドライバクラスを返す。
	 * 
	 * <pre>
	 * e.g. &quot;com.mysql.jdbc.Driver&quot;
	 * </pre>
	 * 
	 * @return JDBCドライバクラス
	 */
	String driver();

	/**
	 * JDBCのURLを返す。
	 * 
	 * <pre>
	 * &quot;jdbc:mysql://127.0.0.1/database_name&quot;
	 * </pre>
	 * 
	 * @return JDBC URL
	 */
	String url();

	/**
	 * データベースのユーザー名を返す。
	 * 
	 * @return データベースのユーザー名
	 */
	String username();

	/**
	 * データベースのパスワードを返す。
	 * 
	 * @return パスワード
	 */
	String password();

	/**
	 * データベースへの接続方法を返す。 "DBCP"であればデータソースを利用する。それ以外であればDriverManagerを利用する。
	 * 
	 * @return 接続方法
	 */
	String datasource() default "";

	/**
	 * データベースのスキーマを返す。
	 * 
	 * @return スキーマ
	 */
	String schema() default "";

	/**
	 * スイート全体のデフォルトとするデータベース操作方法を返す
	 * 
	 * @return データベース操作方法
	 */
	DatabaseOperationType defaultOperation() default DatabaseOperationType.NONE;
}
