package org.dbunitng.annotations;

/**
 * ファイルの種類。 DbUnitではデータを記述するファイルとしてXMLとExcelが利用できる。
 * 
 * @author jyukutyo
 * 
 */
public enum FileType {

	XML("xml"),

	EXCEL("xls"),

	CSV("csv");

	/** 拡張子 */
	private String extension;

	/**
	 * privete constructor。
	 * 
	 * @param e
	 *            拡張子
	 */
	private FileType(String e) {
		this.extension = e;
	}

	@Override
	public String toString() {
		return extension;
	}
}
