package org.dbunitng.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import org.apache.commons.lang.StringUtils;

/**
 * プロパティ関連のユーティリティ。
 * 
 * @author jyukutyo
 * 
 */
public class PropertyUtil {

	/**
	 * Java Beans仕様のプロパティ名にする。
	 * 
	 * <pre>
	 * decapitalizePropertyName(&quot;FirstName&quot;) = &quot;firstName&quot;
	 * decapitalizePropertyName(&quot;AName&quot;) = &quot;AName&quot;
	 * </pre>
	 * 
	 * @param name
	 * @return プロパティ名
	 */
	public static String decapitalizePropertyName(String name) {
		if (StringUtils.isEmpty(name)) {
			return name;
		}
		if (name.length() > 1 && Character.isUpperCase(name.charAt(1))
			&& Character.isUpperCase(name.charAt(0))) {

			return name;
		}
		char chars[] = name.toCharArray();
		chars[0] = Character.toLowerCase(chars[0]);
		return new String(chars);
	}

	/**
	 * インスタンスフィールドかを返す。
	 * 
	 * @param field
	 * @return インスタンスフィールドならtrue
	 */
	public static boolean isInstanceField(Field field) {
		int modifier = field.getModifiers();
		return !Modifier.isStatic(modifier) && !Modifier.isFinal(modifier);
	}

	/**
	 * パブリックフィールドかを返す。
	 * 
	 * @param field
	 * @return パブリックフィールドならtrue
	 */
	public static boolean isPublicField(Field field) {
		int modifier = field.getModifiers();
		return Modifier.isPublic(modifier);
	}
}
