/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.dbunitng.annotations;

/**
 * ファイルの種類。 DbUnitではデータを記述するファイルとしてXMLとExcelが利用できる。
 * 
 * @author jyukutyo
 * 
 */
public enum FileType {

	XML("xml"),

	EXCEL("xls"),

	CSV("csv");

	/** 拡張子 */
	private String extension;

	/**
	 * privete constructor。
	 * 
	 * @param e
	 *            拡張子
	 */
	private FileType(String e) {
		this.extension = e;
	}

	@Override
	public String toString() {
		return extension;
	}
}
