#
# dcast: Check something.

require "etc"

def check_uid()
  pw = Etc.getpwuid(Process.uid) or return nil
  if pw.name != "root"
    puts "change root user"
    exit
  end
end

def check_file_exist(files)
  for file in files
    if !FileTest.exist?(file)
      puts "No exist " + file
      exit
    end
  end
end

def check_dir_exist(dir)
  if FileTest.exist?(dir)
    str = "Do you delete " + dir + "? (Y/n)"
    while buf = Readline.readline(str)
      if buf == "Y" || buf == "y" || buf == "Yes" || buf == "yes"
        FileUtils.rm_r(dir)
        break
      elsif buf == "N" || buf == "n" || buf == "No" || buf == "no"
        puts "Exit DCAST"
        exit
      end
    end
  end
end
