/*
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define VUART_PARAM_SEND_LOW_WATERMARK	0
#define VUART_PARAM_RECV_HIGH_WATERMARK	1
#define VUART_PARAM_IRQ_MASK		2
#define VUART_PARAM_RECV_BUF_SIZE_MAX	3
#define VUART_PARAM_RECV_BUF_SIZE	4
#define VUART_PARAM_SEND_BUF_SIZE_MAX	5
#define VUART_PARAM_SEND_BUF_SIZE	6

#define VUART_IRQ_MASK_SEND		(1UL<<(63-63))
#define VUART_IRQ_MASK_RECV		(1UL<<(63-62))
#define VUART_IRQ_MASK_DISCONNECT	(1UL<<(63-61))

typedef void (*vuart_callback_t)(void);

int vuart_set_callback(unsigned int port, vuart_callback_t func);
int vuart_set_recv_watermark(unsigned int port, unsigned long size);
int vuart_set_irq_mask(unsigned int port, unsigned long mask);
