/*
 * Include file to define the Lv-1 interfaces
 *
 * Author: source@mvista.com
 *
 * 2003, 2004 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#ifndef _PPC64_LV1CALL_H
#define _PPC64_LV1CALL_H

#include <linux/config.h>
#ifndef __ASSEMBLY__
#include <linux/interrupt.h>
#endif

/* ------------------------------------------------------------------------- */
/* utility functions to provide common services related to LV1 */

#ifndef __ASSEMBLY__


extern int __ps3pf_connect_irq(
        unsigned long   outlet_id,
        unsigned int    *irq_no,
        unsigned int    *cpu,
        irqreturn_t     (*handler)(int, void *, struct pt_regs *),
        unsigned long   flags,
        const char      *irq_name,
        void            *dev_id
        );

extern int __ps3pf_free_irq(
	unsigned long outlet_id,
	unsigned int irq_no,
	unsigned int irq_cpu,
	void *dev_id);

extern int ps3pf_connect_irq(
        unsigned long   *outlet_id,
        unsigned int    *irq_no,
        unsigned int    *cpu,
        irqreturn_t     (*handler)(int, void *, struct pt_regs *),
        unsigned long   flags,
        const char      *irq_name,
        void            *dev_id
        );

extern int ps3pf_free_irq(
	unsigned long outlet_id,
	unsigned int irq_no,
	unsigned int irq_cpu,
	void *dev_id);

extern int ps3pf_connect_io_irq(
	unsigned long intr_id,
	unsigned int *irq_no);

extern int ps3pf_get_io_irq(
	unsigned long intr_id,
	int *irq_no);

extern int ps3pf_connect_spu_irq(
	unsigned long	lspu_id,
	unsigned int	class,

	unsigned long	*outlet_id,
	unsigned int	*irq_no,
	unsigned int	*irq_cpu,

	/* arguments to request_irq() */
	irqreturn_t	(*handler)(int, void *, struct pt_regs *),
	unsigned long	flags,
	const char	*irq_name,
	void		*dev_id);

extern int ps3pf_free_spu_irq(
	unsigned long outlet_id,
	unsigned int irq_no,
	unsigned int irq_cpu,
	void *dev_id);

extern void __init ps3pf_hookup_ipi(int nr);
extern void ps3pf_cause_ipi(int ipi, int procno);

/* PLUG_ID_LIMIT must be <= (NR_IRQS - 1) */
#define LV1_PLUG_ID_LIMIT 256
#define LV1_RESERVED_PLUG_ID_LIMIT 128

#endif /* __ASSEMBLY__ */


/* ------------------------------------------------------------------------- */
/* APIs to access LV1 */

/* Status Codes */
#define L1_ST_SUCCESS				0
/*                                              -1 */
#define L1_ST_RESOURCE_SHORTAGE			-2
#define L1_ST_NO_PRIVILEGE			-3
#define L1_ST_DENIED_BY_POLICY			-4
#define L1_ST_ACCESS_VIOLATION			-5
#define L1_ST_NO_ENTRY				-6
#define L1_ST_DUPLICATE_ENTRY			-7
#define L1_TYPE_MISMATCH			-8
#define L1_ST_BUSY				-9
#define L1_ST_EMPTY				-10
#define L1_ST_WRONG_STATE			-11
/*                                              -12 */
#define L1_ST_NO_MATCH				-13
#define L1_ST_ALREADY_CONNECTED			-14
#define L1_ST_UNSUPPORTED_PARAMETER_VALUE	-15
#define L1_ST_CONDITION_NOT_SATISFIED		-16
#define L1_ST_ILLEGAL_PARAMETER_VALUE		-17
#define L1_ST_BAD_OPTION			-18
#define L1_ST_IMPLEMENTATION_LIMITATION		-19
#define L1_ST_NOT_IMPLEMENTED			-20
#define L1_ST_INVALID_CLASS_ID			-21
#define L1_ST_CONSTRAINT_NOT_SATISFIED		-22
#define L1_ST_ALIGNMENT_ERROR			-23
#define L1_ST_INTERNAL_ERROR			-32768

#ifdef __ASSEMBLY__

#define LV1CALL_OPCODE	0x44000022

#define lv1call	.long LV1CALL_OPCODE; extsw r3, r3

#endif /* __ASSEMBLY__ */

#ifndef __ASSEMBLY__

/* values for lv1_allocate_memory */
/* destruction_scheme */
/* bit 63:transferability */
#define LV1_AM_TF_NO			0x00
#define LV1_AM_TF_YES			0x01
/* bit 62:destruction_scheme */
#define LV1_AM_DS_NO_CONNECTIONS	0x00
#define LV1_AM_DS_ANYTIME		0x02
/* bit 61:fail or alternative */
#define LV1_AM_FA_FAIL			0x00
#define LV1_AM_FA_ALTERNATIVE		0x04
/* bit 60:need LPAR address 0 */
#define LV1_AM_ADDR_ANY			0x00
#define LV1_AM_ADDR_0			0x08

/* values for lv1_shutdown_logical_partition */
#define LV1_SHUTDOWN_LP_HALT		1
#define LV1_SHUTDOWN_LP_POWER_OFF	2
#define LV1_SHUTDOWN_LP_RESTART		3

/* values for lv1_set_spu_privileged_state_1_registters  */
#define LV1_SPU_PRIV1_MFC_SR1		0x0000
#define LV1_SPU_PRIV1_MFC_SR1_MASK		0x0000000000000009
#define LV1_SPU_PRIV1_MFC_SR1_INITIAL		0x0000000000000033
#define LV1_SPU_PRIV1_MFC_ACCR		0x0600
#define LV1_SPU_PRIV1_MFC_ACCR_MASK		0x000000000000001b
#define LV1_SPU_PRIV1_MFC_TLB_RMT_DATA	0x0710
#define LV1_SPU_PRIV1_MFC_TLB_RMT_DATA_MASK	0x000000000000ffff
#define LV1_SPU_PRIV1_MFC_LSACR		0x0808
#define LV1_SPU_PRIV1_MFC_LSACR_MASK		0x000000001f1f1fe1
#define LV1_SPU_PRIV1_MFC_TCLASSID	0x0820
#define LV1_SPU_PRIV1_MFC_TCLASSID_MASK		0x0003ffff0003ffff

/*
 * Lv-1 call prototype definitions
 */
#include "lv1callarg.h"

#define LV1_CALL(name, in, out, num) \
	extern long _lv1_##name(LV1_##in##_IN_##out##_OUT_ARG_DECL);

#include "lv1calltab.h"

#undef LV1_CALL

/*
 * Lv-1 call wrappers
 */
#define LV1_CALL(NAME, IN, OUT, NUM)					\
static inline int lv1_##NAME(LV1_##IN##_IN_##OUT##_OUT_ARG_DECL)	\
{									\
	return _lv1_##NAME(LV1_##IN##_IN_##OUT##_OUT_ARGS);		\
}

#include "lv1calltab.h"

#undef LV1_CALL

#endif /* __ASSEMBLY__ */

#endif /* _PPC64_LV1CALL_H */
