#
# dcast: Convert configration files
# eg. /etc/hoss, /etc/pxe.conf

def hosts_config(ip, name, domain)
  io = File.open("/etc/hosts", "a+")
  io.puts "\n# dcast create"
  ip.size.times{|a|
    io.puts ip[a] + "\t" + name[a] + "\t" + name[a] + "." + domain
  }
  io.puts "# dcast end"
end

def pxe_config(eth, ip) #tftpbasedir?
  path = Path.new

  open(path.pxe + ".2", "w"){|pxe|
    pxe.puts "# which interface to use"
    pxe.puts "interface=" + eth
    pxe.puts "default_address=" + ip
    open(path.pxe, "r+"){|io|
      while line = io.gets
        unless line =~ /^interface/ || line =~ /^\# which interface to use/ || line =~ /^default_address/
          pxe.puts line
        end
      end
    }
  }
  File.rename(path.pxe + ".2", path.pxe)

  FileUtils.mkdir_p(path.tftpboot + "/pxelinux.cfg")
  open(path.tftpboot + "/pxelinux.cfg/default", "w"){|io|
    io.print <<"EOB"
DEFAULT linux

LABEL linux
  KERNEL bzImage
  APPEND initrd=initrd.img root=/dev/nfs nfsroot=#{ip}:#{path.tftpboot}/boot ip=dhcp init=/etc/init.d/dcast-detect.sh
  IPPEND 0
EOB
  }

  FileUtils.cp(path.pxe_kernel, path.tftpboot)
end

def nfs_config(nwork, nmask)
  path = Path.new
  select_dir = Array.new
  unselect_dir = ["/lost+found", "/tmp", "/proc", "/mnt", "/floppy", "/cdrom", "/media", "/etc", "/boot", "/dev", "/var", "/sys"]

  Dir.glob("/*").each{|lsdir|
    if FileTest.directory?(lsdir) && !FileTest.symlink?(lsdir)
      select_dir.push(lsdir)
    end
  }
  select_dir = select_dir - unselect_dir
  select_dir.push("/tftpboot")

  open(path.fstab_conf, "r"){|io|
    while line = io.gets
      dir = line.split[0].split(/:/)[1]
      select_dir.push(dir) if FileTest.exist?(dir)
    end
  }

  open("/etc/exports","w"){|io|
    io.print <<EOF
# /etc/exports: the access control list for filesystems which may be exported
#               to NFS clients.  See exports(5).
EOF
    select_dir.uniq.each{|dir|
      io.puts "#{dir}     #{nwork}/#{nmask}(sync,no_root_squash,no_subtree_check,rw)"
    }
  }
end

def rsh_config(name)
  File.open("/etc/hosts.equiv", "a+"){|io|
    io.puts "\n# dcast create"
    name.size.times{|a|
      io.puts name[a].split(/\./)[0]
    }
    io.puts "# dcast end"
  }
end

def rhosts_config(name)
  File.open("/root/.rhosts", "a+"){|io|
    io.puts "\n# dcast create"
    name.size.times{|a|
      io.puts name[a].split(/\./)[0]
    }
    io.puts "# dcast end"
  }
end

def mpich_config(mpich, name)
  File.open(mpich, "w"){|io|
    io.puts "\n# dcast create"
    name.size.times{|a|
      io.puts name[a].split(/\./)[0]
    }
    io.puts "# dcast end"
  }
end

def dhcpd_config(dhcp, dhcp_i, tftpboot, master_eth, master_ip, nwork, nmask, bcast, slave_name, slave_ip, slave_mac)
  File.open(dhcp_i, "w"){|io|
    io.puts "# dcast create"
    io.puts "INTERFACES=\"" + master_eth + "\""
    io.puts "# dcast end"
  }

start = nwork.split(/\./).reverse[0].to_i + 1
last = bcast.split(/\./).reverse[0].to_i - 1

start = nwork.split(/\./)[0] + "." + nwork.split(/\./)[1] + "." + nwork.split(/\./)[2] + "." + start.to_s
last = nwork.split(/\./)[0] + "." + nwork.split(/\./)[1] + "." + nwork.split(/\./)[2] + "." + last.to_s

  File.open(dhcp, "w"){|io|
    io.print <<"EOB"
# dcast create
server-identifier #{master_ip};
log-facility local7;

subnet #{nwork} netmask #{nmask} {
      range #{start} #{last};
      deny unknown-clients;

group {
  use-host-decl-names on;
  next-server #{master_ip};
EOB
  }

  File.open(dhcp, "a"){|io|
    slave_name.each_with_index{|name, i|
      io.puts "  host " + name.split(/\./)[0] + "{"
      io.puts "    hardware ethernet " + slave_mac[i] + ";"
      io.puts "    fixed-address " + slave_ip[i] + ";"
      io.puts "    option root-path \"#{tftpboot}/boot\";"
      io.puts "    filename \"#{tftpboot}/bzImage\";"
      io.puts "  }\n"
    }
    io.puts "}"
    io.puts "}"
  }
end
