/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.dddsupport.basegenerator.model;

import jp.osdn.dddsupport.basegenerator.model.AbstractClass;
import jp.osdn.dddsupport.basegenerator.model.ClassName;
import jp.osdn.dddsupport.basegenerator.model.CriteriaClass;
import jp.osdn.dddsupport.basegenerator.model.DetailClass;
import jp.osdn.dddsupport.basegenerator.model.Field;
import jp.osdn.dddsupport.basegenerator.model.FieldName;
import jp.osdn.dddsupport.basegenerator.model.FirstClassCollectionClass;
import jp.osdn.dddsupport.basegenerator.model.IdentityClass;
import jp.osdn.dddsupport.basegenerator.model.JavaSourceBuilder;
import jp.osdn.dddsupport.basegenerator.model.PackageName;
import jp.osdn.dddsupport.basegenerator.model.RepositoryInterface;
import jp.osdn.dddsupport.basegenerator.model.SummaryClass;
import jp.osdn.dddsupport.basegenerator.model.TypeEnum;

public class BaseClass
extends AbstractClass {
    private Field identityField = this.toIdentityClass().toField();
    private Field detailField = this.toDetailClass().toField();

    public BaseClass(PackageName packageName, ClassName className) {
        super(packageName, className);
    }

    public IdentityClass toIdentityClass() {
        return new IdentityClass(this.packageName, this.className.appendClassName("Identity"));
    }

    public DetailClass toDetailClass() {
        return new DetailClass(this.packageName, this.className.appendClassName("Detail"));
    }

    public CriteriaClass toCriteriaClass() {
        return new CriteriaClass(this.packageName, this.className.appendClassName("Criteria"));
    }

    public FirstClassCollectionClass toFirstClassCollectionClass() {
        return new FirstClassCollectionClass(this.packageName, this.className.appendClassName("s"), this.toSummaryClass(), new FieldName("sumarry"));
    }

    public SummaryClass toSummaryClass() {
        return new SummaryClass(this.packageName, this.className.appendClassName("Summary"));
    }

    public RepositoryInterface toRepositoryInterface() {
        return new RepositoryInterface(this.packageName, this.className.appendClassName("Repository"));
    }

    public TypeEnum toTypeEnum() {
        return new TypeEnum(this.packageName, this.className.appendClassName("Type"));
    }

    @Override
    public String writeCode() {
        JavaSourceBuilder builder = new JavaSourceBuilder(this.packageName);
        return builder.className(this.className).build();
    }
}

