/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.deculture.sh;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShCat
implements ShProcess {
    private static final int NUMBER = 1;
    private static final int NUMBER_NONBLANK = 2;
    private static final int SQUEEZE_BLANK = 4;
    private static final int SHOW_NONPRINTING = 8;
    private static final int SHOW_ENDS = 16;
    private static final int SHOW_TABS = 32;
    private static final int BINARY = 64;
    private static final char[] CARET = new char[]{'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_'};

    private void printcaret(OutputStream out, int c) throws IOException {
        if (c < 32) {
            out.write(94);
            out.write(CARET[c]);
        } else if (c == 127) {
            out.write(94);
            out.write(63);
        } else {
            out.write((char)c);
        }
    }

    private int analyzeopt(String s, int[] f) {
        int i = 1;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case 'b': {
                    f[0] = f[0] | 2;
                    break;
                }
                case 'e': {
                    f[0] = f[0] | 8;
                    f[0] = f[0] | 0x10;
                    break;
                }
                case 'n': {
                    f[0] = f[0] | 1;
                    break;
                }
                case 's': {
                    f[0] = f[0] | 4;
                    break;
                }
                case 't': {
                    f[0] = f[0] | 8;
                    f[0] = f[0] | 0x20;
                    break;
                }
                case 'u': {
                    break;
                }
                case 'v': {
                    f[0] = f[0] | 8;
                    break;
                }
                case 'A': {
                    f[0] = f[0] | 8;
                    f[0] = f[0] | 0x10;
                    f[0] = f[0] | 0x20;
                    break;
                }
                case 'B': {
                    f[0] = f[0] | 0x40;
                    break;
                }
                case 'E': {
                    f[0] = f[0] | 0x10;
                    break;
                }
                case 'T': {
                    f[0] = f[0] | 0x20;
                    break;
                }
                default: {
                    return s.charAt(i);
                }
            }
            ++i;
        }
        return -1;
    }

    private boolean isblank(ByteArrayOutputStream b, int fl) {
        if (b.size() > 3) {
            return false;
        }
        if (b.size() == 0) {
            return true;
        }
        byte[] a = b.toByteArray();
        if (a.length == 1) {
            return a[0] == 10;
        }
        if (a.length == 2 && (fl & 0x10) == 0) {
            return a[0] == 13 && a[1] == 10;
        }
        if (a.length == 2 && (fl & 0x10) != 0) {
            return a[0] == 36 && a[1] == 10;
        }
        if (a.length == 3 && (fl & 0x10) != 0) {
            return a[0] == 36 && a[1] == 13 && a[2] == 10;
        }
        return false;
    }

    private void write1(OutputStream out, int fl, int c) throws IOException {
        if (c == 9) {
            if ((fl & 0x20) != 0) {
                out.write(94);
                out.write(73);
            } else {
                out.write((char)c);
            }
        } else if (c < 32 || c == 127) {
            if ((fl & 8) != 0) {
                this.printcaret(out, c);
            } else {
                out.write((char)c);
            }
        } else if (c >= 128) {
            if ((fl & 8) != 0) {
                out.write(77);
                out.write(45);
                this.printcaret(out, (char)(c - 128));
            } else {
                out.write((char)c);
            }
        } else {
            out.write((char)c);
        }
    }

    private boolean catline(InputStream in, OutputStream out, int fl) throws IOException {
        int c;
        int k = 0;
        while ((c = in.read()) >= 0) {
            if (c == 10) {
                if ((fl & 0x10) != 0) {
                    out.write(36);
                }
                out.write((char)c);
                return true;
            }
            if (c != 13 || (fl & 0x40) != 0) {
                this.write1(out, fl, (char)c);
            } else {
                c = in.read();
                if (c == 10) {
                    if ((fl & 0x10) != 0) {
                        out.write(36);
                    }
                    out.write((char)c);
                    return true;
                }
                this.write1(out, fl, 13);
                this.write1(out, fl, (char)c);
            }
            ++k;
        }
        return k > 0;
    }

    private void cat(InputStream ins, PrintStream out, int fl, int[] n) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(ins);
        boolean s = false;
        boolean t = false;
        ByteArrayOutputStream d = null;
        while (t || this.catline(in, b, fl)) {
            if (t) {
                t = false;
                b = d;
                d = null;
            } else {
                if ((fl & 4) != 0 && this.isblank(b, fl)) {
                    b = new ByteArrayOutputStream();
                    s = true;
                    continue;
                }
                if (s) {
                    t = s;
                    s = false;
                    d = b;
                    b = new ByteArrayOutputStream();
                    if ((fl & 0x10) != 0) {
                        out.write(36);
                    }
                    b.write(10);
                }
            }
            if ((fl & 2) != 0 && !this.isblank(b, fl) || (fl & 1) != 0) {
                out.print(String.format("%7d ", n[0]));
                n[0] = n[0] + 1;
            }
            out.write(b.toByteArray());
            b = new ByteArrayOutputStream();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        block31: {
            ins = null;
            f = new int[1];
            n = new int[1];
            k = 1;
            f[0] = 0;
            while (k < args.length) {
                if (args[k].startsWith("-") && !args[k].startsWith("--")) {
                    if (this.analyzeopt(args[k], f) >= 0) {
                        err.println("cat: invalid option");
                        return 2;
                    }
                } else if (args[k].equals("--number")) {
                    f[0] = f[0] | 1;
                } else if (args[k].equals("--number-nonblank")) {
                    f[0] = f[0] | 2;
                } else if (args[k].equals("--squeeze-blank")) {
                    f[0] = f[0] | 4;
                } else if (args[k].equals("--show-nonprinting")) {
                    f[0] = f[0] | 8;
                } else if (args[k].equals("--show-all")) {
                    f[0] = f[0] | 8;
                    f[0] = f[0] | 16;
                    f[0] = f[0] | 32;
                } else if (args[k].equals("--show-ends")) {
                    f[0] = f[0] | 16;
                } else if (args[k].equals("--show-tabs")) {
                    f[0] = f[0] | 32;
                } else if (args[k].equals("--binary")) {
                    f[0] = f[0] | 64;
                } else {
                    if (args[k].equals("--")) {
                        ++k;
                        break;
                    }
                    if (args[k].equals("-") || !args[k].startsWith("-")) break;
                    err.println("cat: invaild arguments");
                    return 2;
                }
                ++k;
            }
            n[0] = 1;
            if (k < args.length) ** GOTO lbl69
            this.cat(in, out, f[0], n);
            break block31;
lbl-1000:
            // 1 sources

            {
                if (args[k].equals("-")) {
                    this.cat(in, out, f[0], n);
                } else {
                    try {
                        ins = fs.getFile(args[k]).getInputStream();
                        if (ins == null) {
                            err.print("cat: ");
                            err.print(args[k]);
                            err.println(": file not found");
                            return 2;
                        }
                        this.cat(ins, out, f[0], n);
                    }
                    finally {
                        if (ins != null) {
                            ins.close();
                        }
                        ins = null;
                    }
                }
                ++k;
lbl69:
                // 2 sources

                ** while (k < args.length)
            }
        }
        return 0;
    }
}

