/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.util.ArrayList;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;

public abstract class AbstractShFile
implements ShFile {
    protected ShFileSystem filesystem;
    protected String virtualpath;

    public AbstractShFile(ShFileSystem fs, String virtualpath) {
        this.filesystem = fs;
        this.virtualpath = virtualpath;
    }

    @Override
    public ShFile toAbsolute() {
        if (this.virtualpath.equals("/")) {
            return this.filesystem.getRoot();
        }
        if (this.virtualpath.length() > 0 && this.virtualpath.charAt(0) == '/') {
            return this.filesystem.getFile(this.virtualpath);
        }
        return this.filesystem.getFile(this.filesystem.getCurrentDirectory().toString(), this.virtualpath);
    }

    @Override
    public ShFile toCanonical() {
        String[] a;
        ArrayList<String> l = new ArrayList<String>();
        StringBuffer b = new StringBuffer("");
        if (this.virtualpath.equals("/")) {
            return this.filesystem.getRoot();
        }
        String[] stringArray = a = this.toAbsolute().toString().replaceFirst("/+", "").split("/");
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (!t.equals(".")) {
                if (!t.equals("..")) {
                    l.add(t);
                } else if (l.size() > 0) {
                    l.remove(l.size() - 1);
                }
            }
            ++n2;
        }
        for (String t : l) {
            b.append("/").append(t);
        }
        return this.filesystem.getFile(b.toString());
    }

    public String toString() {
        return this.virtualpath;
    }
}

