/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.util.List;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;

public abstract class AbstractShFileSystem
implements ShFileSystem {
    protected ShFile realcur;

    public static String normalizePath(String s) {
        String v;
        String t = s.replaceFirst("^/+", "/");
        t = t.replaceFirst("/+$", "");
        t = t.replaceAll("^(/\\.\\.)+", "/");
        do {
            v = t;
        } while (!(t = t.replaceAll("/[^/]+/\\.\\.", "")).equals(v));
        t = t.replaceAll("(/\\.)+/", "/");
        t = (t = t.replaceAll("(/\\.)+$", "")).equals("") ? "/" : t;
        return t;
    }

    @Override
    public ShFile getCurrentDirectory() {
        return this.realcur;
    }

    @Override
    public void setCurrentDirectory(ShFile s) {
        this.realcur = s.toCanonical();
    }

    @Override
    public ShFile searchPath(ShEnvironment env, String name) {
        List<String> p = env.getPath();
        if (name.length() == 0 || name.charAt(0) == '/') {
            return this.getFile(name);
        }
        for (String t : p) {
            ShFile f = this.getFile(t);
            if (f == null || !f.isDirectory() || (f = this.getFile(t, name)) == null || !f.isExecutable()) continue;
            return f;
        }
        return null;
    }
}

