/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.InputStream;
import java.io.PrintStream;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShStat;

public abstract class AbstractShVirtualDirectory
implements ShFile {
    private String current;
    private ShFile parent;

    public AbstractShVirtualDirectory(ShFile parentFile, String currentName) {
        if (parentFile != null && currentName == null) {
            throw new NullPointerException();
        }
        this.parent = parentFile;
        this.current = currentName;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public String getName() {
        return this.current != null ? this.current : "";
    }

    @Override
    public PrintStream getPrintStream(boolean append) {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public boolean isExist() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public long getLastModified() {
        return Long.MIN_VALUE;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isZeroFile() {
        return false;
    }

    @Override
    public ShProcess getProcess() {
        return null;
    }

    @Override
    public ShFile toAbsolute() {
        return this;
    }

    @Override
    public ShFile toCanonical() {
        return this;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean renameTo(ShFile f) {
        return false;
    }

    @Override
    public void setLastModified(long time) {
    }

    @Override
    public boolean rmdir() {
        return false;
    }

    @Override
    public boolean deleteFile() {
        return false;
    }

    @Override
    public ShStat getStat() {
        return new ShStat(this.toString(), 0L, 0L, 15);
    }

    public String toString() {
        return String.valueOf(this.parent != null ? this.parent.toString() : "") + "/" + this.getName();
    }
}

