/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShRedirector;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShRuntimeException;
import net.morilib.sh.ShString;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;
import net.morilib.unix.glob.Wildcard;

public final class ShFiles {
    private static final Pattern PT = Pattern.compile("/+");

    public static List<ShFile> glob(String filename, ShFileSystem fs) {
        String[] a;
        List<ShFile> r;
        ArrayList<ShFile> s = new ArrayList<ShFile>();
        int p = 0;
        if (filename.length() == 0) {
            return Collections.emptyList();
        }
        Matcher m = PT.matcher(filename);
        if (m.lookingAt()) {
            r = Collections.singletonList(fs.getRoot());
            p = m.end();
        } else {
            r = Collections.singletonList(fs.getCurrentDirectory());
        }
        String[] stringArray = a = filename.substring(p).replaceFirst("/+$", "").split("/+");
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            Wildcard w = Wildcard.compile(t);
            s = new ArrayList();
            for (ShFile f : r) {
                s.addAll(f.getFiles());
            }
            r = new ArrayList<ShFile>();
            for (ShFile f : s) {
                if (f.isHidden() || !w.matches(f.getName())) continue;
                r.add(f);
            }
            ++n2;
        }
        return r;
    }

    public static ShProcess findCommand(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, String name) {
        ShProcess p = cmds.find(name);
        if (p != null) {
            return p;
        }
        ShFile f = fs.searchPath(env, name);
        if (f != null && (p = f.getProcess()) != null) {
            return p;
        }
        return null;
    }

    public static InputStream redirect(ShEnvironment env, ShFileSystem fs, ShRuntime run, ShRedirector r, ShToken file, InputStream stdin, PrintStream[] out, XtraceStream p) throws IOException, ShSyntaxException {
        InputStream in;
        block18: {
            block21: {
                block19: {
                    block20: {
                        block17: {
                            in = stdin;
                            if (!r.isFileRedirector()) break block17;
                            String v = ShTrees.substituteCase(env, run, fs, out[2], p, file);
                            block0 : switch (r.getType()) {
                                case IN: {
                                    switch (r.getFDSource()) {
                                        case 0: {
                                            in = fs.getFile(v).getInputStream();
                                            break block0;
                                        }
                                    }
                                    throw new ShSyntaxException();
                                }
                                case OUT: {
                                    if (env.isSet("noclobber")) {
                                        throw new ShRuntimeException();
                                    }
                                }
                                case APPEND: {
                                    switch (r.getFDSource()) {
                                        case 1: 
                                        case 2: {
                                            out[r.getFDSource()] = fs.getFile(v).getPrintStream(r.isAppend());
                                            break block0;
                                        }
                                    }
                                    throw new ShSyntaxException();
                                }
                            }
                            break block18;
                        }
                        if (!r.isDescriptorCopier()) break block19;
                        if (r.getFDDestination() < 1 && r.getFDDestination() > 2) {
                            throw new ShSyntaxException();
                        }
                        if (r.getFDSource() < 1 && r.getFDSource() > 2) {
                            throw new ShSyntaxException();
                        }
                        if (r.getFDSource() == r.getFDDestination()) break block20;
                        out[r.getFDSource()] = out[r.getFDDestination()];
                        break block18;
                    }
                    throw new ShSyntaxException();
                }
                if (!r.isHereDocument()) break block21;
                switch (r.getFDSource()) {
                    case 0: {
                        String v = r.getDocument();
                        v = ShTrees.substituteCase(env, run, fs, out[2], p, new ShString(v));
                        in = new ByteArrayInputStream(v.getBytes());
                        break block18;
                    }
                    default: {
                        throw new ShSyntaxException();
                    }
                }
            }
            throw new RuntimeException();
        }
        return in;
    }
}

