/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.conf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.morilib.sh.AbstractShEnvironment;
import net.morilib.sh.AbstractShFile;
import net.morilib.sh.AbstractShFileSystem;
import net.morilib.sh.DefaultShRuntime;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShCommandNotFoundException;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShExitException;
import net.morilib.sh.ShFacade;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShLexer;
import net.morilib.sh.ShParser;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShPromptReader;
import net.morilib.sh.ShRealFile;
import net.morilib.sh.ShRootShellEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShRuntimeException;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShStat;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.conf.NormalVariable;
import net.morilib.sh.conf.PropertyVariable;
import net.morilib.sh.conf.ShConfigException;
import net.morilib.sh.conf.SpecialDir;
import net.morilib.sh.conf.SpecialFile;
import net.morilib.sh.conf.SpecialVariable;
import net.morilib.sh.misc.IOs;
import net.morilib.sh.misc.XtraceStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ShFactory {
    private XmlEnv env = new XmlEnv(null, null);
    private XmlCmd cmd = new XmlCmd();
    private XmlFS filesystem = new XmlFS();
    private InputStream stdin;
    private PrintStream stdout;
    private PrintStream stderr;

    private ShFactory() {
    }

    private static Object getcls(String n) throws ShConfigException {
        try {
            Class<?> c = Class.forName(n);
            Object r = c.newInstance();
            return r;
        }
        catch (ClassNotFoundException e) {
            throw new ShConfigException(e);
        }
        catch (InstantiationException e) {
            throw new ShConfigException(e);
        }
        catch (IllegalAccessException e) {
            throw new ShConfigException(e);
        }
    }

    private static Object getcls(String n, ShFileSystem fs, String vp, String nm) throws ShConfigException {
        try {
            Class<?> c = Class.forName(n);
            Constructor<?> o = c.getConstructor(ShFileSystem.class, String.class, String.class);
            Object r = o.newInstance(fs, vp, nm);
            return r;
        }
        catch (ClassNotFoundException e) {
            throw new ShConfigException(e);
        }
        catch (InstantiationException e) {
            throw new ShConfigException(e);
        }
        catch (IllegalAccessException e) {
            throw new ShConfigException(e);
        }
        catch (SecurityException e) {
            throw new ShConfigException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ShConfigException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ShConfigException(e);
        }
        catch (InvocationTargetException e) {
            throw new ShConfigException(e);
        }
    }

    private ShFile parseDir(XmlVDir x, Node d, boolean write) throws ShConfigException {
        ShFile f;
        if (!(d instanceof Element)) {
            if (d.getNodeValue().trim().length() > 0) {
                throw new ShConfigException();
            }
            return null;
        }
        Element l = (Element)d;
        String m = l.getAttribute("name");
        if ((m == null || m.equals("")) && write) {
            throw new ShConfigException();
        }
        String s = l.getTagName();
        if (s.equals("virtual-dir")) {
            XmlVDir y;
            if (x == null) {
                throw new ShConfigException();
            }
            NodeList a = l.getChildNodes();
            f = y = x.createSubdir(m);
            int k = 0;
            while (k < a.getLength()) {
                this.parseDir(y, a.item(k), true);
                ++k;
            }
        } else if (s.equals("standard-io")) {
            String v = l.getAttribute("in");
            InputStream in = v == null ? this.stdin : (v.equals("stdin") ? this.stdin : null);
            v = l.getAttribute("out");
            PrintStream out = v == null ? this.stdout : (v.equals("stdout") ? this.stdout : (v.equals("stderr") ? this.stderr : null));
            f = x.createStdIO(m, in, out);
        } else if (s.equals("string-file")) {
            String v = l.getChildNodes().item(0).getNodeValue();
            f = x.createSFile(m, String.valueOf(v.trim()) + "\n");
        } else if (s.equals("resource-file")) {
            f = x.createJFile(m, l.getAttribute("resource"));
        } else if (s.equals("special-file")) {
            f = x.createDirByReflection(l.getAttribute("class"));
        } else if (s.equals("special-dir")) {
            f = x.createFileByReflection(l.getAttribute("class"));
        } else if (s.equals("multiplex-file")) {
            NodeList a = l.getChildNodes();
            ArrayList<SpecialFile> t = new ArrayList<SpecialFile>();
            int k = 0;
            while (k < a.getLength()) {
                f = this.parseDir(x, a.item(k), false);
                if (f != null) {
                    if (f instanceof SpecialFile) {
                        t.add((SpecialFile)f);
                    } else {
                        throw new ShConfigException();
                    }
                }
                ++k;
            }
            f = x.createCFile(m, t);
        } else if (s.equals("null-file")) {
            f = x.createNFile(m);
        } else {
            String v = l.getAttribute("realpath");
            if (v == null || v.equals("")) {
                throw new ShConfigException();
            }
            if (s.equals("map-dir")) {
                boolean b = "true".equals(l.getAttribute("subdir"));
                boolean c = "true".equals(l.getAttribute("createfile"));
                File r = new File(v);
                if (!r.isDirectory()) {
                    throw new ShConfigException();
                }
                f = x.createRDir(m, r, b, c);
            } else if (s.equals("map-file")) {
                f = x.createRFile(m, new File(v));
            } else {
                throw new ShConfigException();
            }
        }
        if (write) {
            x.files.put(m, f);
        }
        return f;
    }

    private void parseCommand(Node d) throws ShConfigException {
        if (!(d instanceof Element)) {
            if (d.getNodeValue().trim().length() > 0) {
                throw new ShConfigException();
            }
        } else {
            Element l = (Element)d;
            if (l.getTagName().equals("resource-command")) {
                this.cmd.cmds.put(l.getAttribute("name"), (ShProcess)ShFactory.getcls(l.getAttribute("class")));
            } else {
                throw new ShConfigException();
            }
        }
    }

    private void parseEnvironment(Node d) throws ShConfigException {
        if (!(d instanceof Element)) {
            if (d.getNodeValue().trim().length() > 0) {
                throw new ShConfigException();
            }
        } else {
            Element l = (Element)d;
            String s = l.getTagName();
            if (s.equals("variable")) {
                String n = l.getAttribute("name");
                if (n == null || n.equals("")) {
                    throw new ShConfigException();
                }
                s = l.getAttribute("value");
                this.env.put(n, s != null ? s : "");
            } else if (s.equals("property-variable")) {
                String n = l.getAttribute("name");
                if (n == null || n.equals("")) {
                    throw new ShConfigException();
                }
                s = l.getAttribute("property");
                if (s == null || s.equals("")) {
                    throw new ShConfigException();
                }
                this.env.map.put(n, new PropertyVariable(s));
            } else if (s.equals("inherit-variable")) {
                String n = l.getAttribute("name");
                if (n == null || n.equals("")) {
                    throw new ShConfigException();
                }
                s = l.getAttribute("from");
                if (s == null || s.equals("")) {
                    throw new ShConfigException();
                }
                if ((s = System.getenv(s)) != null) {
                    this.env.map.put(n, new NormalVariable(s));
                }
            } else if (s.equals("special-variable")) {
                this.env.map.put(l.getAttribute("name"), (SpecialVariable)ShFactory.getcls(l.getAttribute("class")));
            } else {
                throw new ShConfigException();
            }
        }
    }

    public static ShFactory getInstance(InputStream in, InputStream stdin, PrintStream stdout, PrintStream stderr) throws ShConfigException {
        ShFactory r = new ShFactory();
        r.stdin = stdin;
        r.stdout = stdout;
        r.stderr = stderr;
        try {
            String s;
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder bld = fac.newDocumentBuilder();
            Document doc = bld.parse(in);
            Element rt = doc.getDocumentElement();
            XmlVDir xmlVDir = new XmlVDir(r.filesystem, "/", null);
            r.filesystem.root = xmlVDir;
            XmlVDir di = xmlVDir;
            Node nd = rt.getElementsByTagName("filesystem").item(0);
            NodeList nl = nd.getChildNodes();
            int k = 0;
            while (k < nl.getLength()) {
                r.parseDir(di, nl.item(k), true);
                ++k;
            }
            nd = rt.getElementsByTagName("commands").item(0);
            if (nd instanceof Element && (s = ((Element)nd).getAttribute("usedefault")) != null) {
                s.equals("true");
            }
            nl = nd.getChildNodes();
            k = 0;
            while (k < nl.getLength()) {
                r.parseCommand(nl.item(k));
                ++k;
            }
            r.env.map.put("IFS", new NormalVariable(" \t"));
            r.env.map.put("PATH", new NormalVariable(""));
            nd = rt.getElementsByTagName("environment").item(0);
            nl = nd.getChildNodes();
            k = 0;
            while (k < nl.getLength()) {
                r.parseEnvironment(nl.item(k));
                ++k;
            }
            return r;
        }
        catch (ParserConfigurationException e) {
            throw new ShConfigException(e);
        }
        catch (SAXException e) {
            throw new ShConfigException(e);
        }
        catch (IOException e) {
            throw new ShConfigException(e);
        }
    }

    public static ShFactory getInstance() {
        try {
            return ShFactory.getInstance(ShFactory.class.getResourceAsStream("/net/morilib/sh/conf/nullenv.xml"), System.in, System.out, System.err);
        }
        catch (ShConfigException e) {
            throw new RuntimeException(e);
        }
    }

    private static void _setarg(ShEnvironment n, String[] a) {
        int i = 1;
        while (i <= a.length) {
            n.put(String.valueOf(i), a[i - 1]);
            ++i;
        }
    }

    public int execute(InputStream script, InputStream stdin, PrintStream stdout, PrintStream stderr, Map<String, String> vars, String ... args) throws IOException, ShSyntaxException {
        DefaultShRuntime run = new DefaultShRuntime(this.cmd);
        XtraceStream q = new XtraceStream(stdout);
        XmlEnv env = new XmlEnv(this.env, null, null);
        for (Map.Entry<String, String> t : vars.entrySet()) {
            env.put(t.getKey(), t.getValue());
        }
        ShRootShellEnvironment v = new ShRootShellEnvironment(env);
        ShFactory._setarg(v, args);
        try {
            return ShFacade.execute((ShEnvironment)v, (ShFileSystem)this.filesystem, (ShBuiltInCommands)this.cmd, (ShRuntime)run, script, stdin, stdout, stderr, q);
        }
        catch (ShExitException e) {
            return e.getCode();
        }
    }

    public int execute(InputStream script, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException, ShSyntaxException {
        return this.execute(script, stdin, stdout, stderr, Collections.emptyMap(), args);
    }

    public int execute(InputStream script, PrintStream stdout, PrintStream stderr, Map<String, String> vars, String ... args) throws IOException, ShSyntaxException {
        return this.execute(script, IOs.NULL_INPUT, stdout, stderr, vars, args);
    }

    public int execute(InputStream script, PrintStream stdout, PrintStream stderr, String ... args) throws IOException, ShSyntaxException {
        return this.execute(script, IOs.NULL_INPUT, stdout, stderr, args);
    }

    public int execute(InputStream script, PrintStream stdout, String ... args) throws IOException, ShSyntaxException {
        return this.execute(script, IOs.NULL_INPUT, stdout, new PrintStream(IOs.NULL_OUTPUT), args);
    }

    public int interactive(InputStream stdin, PrintStream stdout, PrintStream stderr) throws IOException {
        int a = 0;
        this.env.bind("PS1", "$ ");
        this.env.bind("PS2", "> ");
        this.filesystem.setCurrentDirectory(this.filesystem.getHome());
        XtraceStream q = new XtraceStream(stdout);
        ShPromptReader p = new ShPromptReader(this.env, q);
        ShLexer r = new ShLexer(this.env, p, q);
        DefaultShRuntime run = new DefaultShRuntime(this.cmd);
        ShRootShellEnvironment v = new ShRootShellEnvironment(this.env);
        while (true) {
            try {
                ShToken t;
                while ((t = r.nextToken()) == ShToken.NEWLINE) {
                }
                ShTree x = ShParser.parseCommand(r, t);
                a = x.eval(v, this.filesystem, this.cmd, run, stdin, stdout, stderr, q);
                if (r.isEof()) {
                    return a;
                }
                r.resetPrompt();
                continue;
            }
            catch (ShExitException e) {
                return e.getCode();
            }
            catch (IOException e) {
                String z = v.getTrap(ShSignal.IO);
                if (z != null) {
                    try {
                        run.eval(v, this.filesystem, stdin, stdout, stderr, q, z);
                    }
                    catch (ShCommandNotFoundException e1) {
                        stderr.print("jsh");
                        stderr.print(": command not found: ");
                        stderr.println(e1.getName());
                    }
                    catch (IOException e1) {
                        stderr.print("jsh");
                        stderr.println(": IO error");
                    }
                    catch (ShSyntaxException e1) {
                        e.printStackTrace();
                        stderr.println("Syntax error");
                    }
                }
                e.printStackTrace(stderr);
                continue;
            }
            catch (ShCommandNotFoundException e) {
                stderr.print("jsh");
                stderr.print(": command not found: ");
                stderr.println(e.getName());
                continue;
            }
            catch (ShSyntaxException e) {
                e.printStackTrace();
                stderr.println("Syntax error");
                continue;
            }
            catch (ShRuntimeException e) {
                e.printStackTrace();
                stderr.println("Syntax error");
                continue;
            }
            break;
        }
    }

    private static class XmlCFile
    extends SpecialFile {
        private List<SpecialFile> files;

        public XmlCFile(ShFileSystem fs, String vp, String name, List<SpecialFile> files) {
            super(fs, vp, name);
            this.files = new ArrayList<SpecialFile>(files);
        }

        @Override
        public boolean isExecutable() {
            for (SpecialFile f : this.files) {
                if (f.isExecutable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isReadable() {
            for (SpecialFile f : this.files) {
                if (f.isReadable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isWritable() {
            for (SpecialFile f : this.files) {
                if (f.isWritable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isZeroFile() {
            for (SpecialFile f : this.files) {
                if (f.isZeroFile()) continue;
                return false;
            }
            return true;
        }

        @Override
        public long getLastModified() {
            long l = Long.MIN_VALUE;
            for (SpecialFile f : this.files) {
                if (l >= f.getLastModified()) continue;
                l = f.getLastModified();
            }
            return l < 0L ? 0L : l;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw new IOException();
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            final PrintStream[] p = new PrintStream[this.files.size()];
            int k = 0;
            while (k < p.length) {
                p[k] = this.files.get(k).getPrintStream(append);
                ++k;
            }
            return new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    PrintStream[] printStreamArray = p;
                    int n = p.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PrintStream s = printStreamArray[n2];
                        ((OutputStream)s).write(b);
                        ++n2;
                    }
                }

                @Override
                public void write(byte[] b) throws IOException {
                    PrintStream[] printStreamArray = p;
                    int n = p.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PrintStream s = printStreamArray[n2];
                        ((OutputStream)s).write(b);
                        ++n2;
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    PrintStream[] printStreamArray = p;
                    int n = p.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PrintStream s = printStreamArray[n2];
                        ((OutputStream)s).write(b, off, len);
                        ++n2;
                    }
                }

                @Override
                public void flush() throws IOException {
                    PrintStream[] printStreamArray = p;
                    int n = p.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PrintStream s = printStreamArray[n2];
                        ((OutputStream)s).flush();
                        ++n2;
                    }
                }

                @Override
                public void close() throws IOException {
                    PrintStream[] printStreamArray = p;
                    int n = p.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PrintStream s = printStreamArray[n2];
                        ((OutputStream)s).close();
                        ++n2;
                    }
                }
            });
        }

        @Override
        public void setLastModified(long time) {
            for (SpecialFile f : this.files) {
                f.setLastModified(time);
            }
        }

        @Override
        public ShStat getStat() {
            ShStat r = new ShStat();
            int f = 0;
            r.setFilename(this.virtualpath);
            r.setMtime(this.getLastModified());
            r.setSize(0L);
            f |= this.isDirectory() ? 8 : 0;
            f |= this.isExecutable() ? 4 : 0;
            f |= this.isWritable() ? 2 : 0;
            r.setFlags(f |= this.isReadable() ? 1 : 0);
            return r;
        }
    }

    private static class XmlCmd
    implements ShBuiltInCommands {
        private Map<String, ShProcess> cmds = new HashMap<String, ShProcess>();

        private XmlCmd() {
        }

        @Override
        public ShProcess find(String name) {
            return this.cmds.get(name);
        }

        @Override
        public Map<String, ShProcess> getCommands() {
            return Collections.unmodifiableMap(this.cmds);
        }
    }

    private static class XmlEnv
    extends AbstractShEnvironment {
        private Map<String, SpecialVariable> map;
        private Map<String, ShEnvironment.Attributes> attrs;

        private XmlEnv() {
            this.map = new HashMap<String, SpecialVariable>();
            this.attrs = new HashMap<String, ShEnvironment.Attributes>();
            this.path = new ArrayList();
        }

        private XmlEnv(XmlEnv x) {
            this.map = new HashMap<String, SpecialVariable>(x.map);
            this.attrs = new HashMap<String, ShEnvironment.Attributes>(x.attrs);
            this.path = new ArrayList(x.path);
        }

        @Override
        public String find(String name) {
            SpecialVariable v = this.map.get(name);
            return v != null ? v.getValue(name) : null;
        }

        @Override
        public void bind(String name, String value) {
            this.put(name, value);
            this.setpath();
        }

        @Override
        public void put(String name, String value) {
            this.map.put(name, new NormalVariable(value));
        }

        @Override
        public boolean contains(String name) {
            return this.map.containsKey(name);
        }

        @Override
        public ShEnvironment getEnvironment() {
            return null;
        }

        @Override
        public Properties toProperties() {
            Properties p = new Properties();
            for (Map.Entry<String, SpecialVariable> t : this.map.entrySet()) {
                p.setProperty(t.getKey(), t.getValue().getValue(t.getKey()));
            }
            return p;
        }

        @Override
        public void export(String name) {
            if (!this.contains(name)) {
                this.map.put(name, new NormalVariable(""));
            }
        }

        @Override
        public void unbind(String name) {
            this.map.remove(name);
        }

        @Override
        public boolean isReadonly(String name) {
            return this.attrs.containsKey(name) && this.attrs.get(name).isReadonly();
        }

        @Override
        public void setReadonly(String name) {
            this.attrs.put(name, READONLY);
        }

        /* synthetic */ XmlEnv(XmlEnv xmlEnv, XmlEnv xmlEnv2) {
            this();
        }

        /* synthetic */ XmlEnv(XmlEnv xmlEnv, XmlEnv xmlEnv2, XmlEnv xmlEnv3) {
            this(xmlEnv);
        }
    }

    private static class XmlFS
    extends AbstractShFileSystem {
        private XmlVDir root;

        private XmlFS() {
        }

        @Override
        public ShFile getRoot() {
            return this.root;
        }

        @Override
        public ShFile getFile(String s) {
            SpecialDir x;
            String t = XmlFS.normalizePath(s);
            if (t.length() == 0) {
                return this.getCurrentDirectory();
            }
            if (t.equals("/")) {
                return this.root;
            }
            if (t.charAt(0) == '/') {
                t = t.substring(1);
                x = this.root;
            } else if (this.realcur == null) {
                x = this.root;
            } else {
                return this.getFile(this.getCurrentDirectory(), s);
            }
            ShFile f = x;
            String[] stringArray = t.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (x == null || (f = ((SpecialDir)x).getFile(v)) == null) {
                    return new XmlInv(this, t);
                }
                x = f instanceof SpecialDir ? (SpecialDir)f : null;
                ++n2;
            }
            return f;
        }

        @Override
        public ShFile getFile(String dir, String name) {
            return this.getFile(String.valueOf(dir) + "/" + name);
        }

        @Override
        public ShFile getFile(ShFile dir, String name) {
            return this.getFile(String.valueOf(dir.toString()) + "/" + name);
        }

        @Override
        public ShFile getNativeFile(String s) {
            return this.getFile(s);
        }

        @Override
        public ShSecurityPolicy getSecurityPolicy() {
            return ShSecurityPolicy.ALL_PERMITTED;
        }

        @Override
        public InputStream getProfile() {
            return null;
        }

        @Override
        public InputStream getRc() {
            return null;
        }

        @Override
        public ShFile getHome() {
            return this.root;
        }
    }

    private static class XmlInv
    extends AbstractShFile {
        public XmlInv(ShFileSystem fs, String vp) {
            super(fs, vp);
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isExist() {
            return false;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            return false;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.virtualpath.replaceFirst(".*/", "");
        }

        @Override
        public Collection<ShFile> getFiles() {
            return Collections.singleton(this);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw new IOException();
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            throw new IOException();
        }

        @Override
        public ShProcess getProcess() {
            return null;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean renameTo(ShFile f) {
            return false;
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public boolean rmdir() {
            return false;
        }

        @Override
        public boolean deleteFile() {
            return false;
        }

        @Override
        public ShStat getStat() {
            return null;
        }
    }

    private static class XmlJFile
    extends SpecialFile {
        private final long time = System.currentTimeMillis();
        private String res;

        public XmlJFile(ShFileSystem fs, String vp, String name, String res) {
            super(fs, vp, name);
            this.res = res;
        }

        private InputStream getstream() {
            return ShFactory.class.getResourceAsStream(this.res);
        }

        /*
         * Exception decompiling
         */
        private long getlength() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            InputStream in = this.getstream();
            if (in == null) {
                return true;
            }
            try {
                return in.read() < 0;
            }
            catch (IOException e) {
                return true;
            }
        }

        @Override
        public long getLastModified() {
            return this.time;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream in = this.getstream();
            if (in == null) {
                throw new IOException();
            }
            return in;
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            throw new IOException();
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public ShStat getStat() {
            ShStat r = new ShStat();
            int f = 0;
            r.setFilename(this.virtualpath);
            r.setMtime(this.time);
            r.setSize(this.getlength());
            f |= this.isDirectory() ? 8 : 0;
            f |= this.isExecutable() ? 4 : 0;
            f |= this.isWritable() ? 2 : 0;
            r.setFlags(f |= this.isReadable() ? 1 : 0);
            return r;
        }
    }

    private static class XmlNFile
    extends SpecialFile {
        public XmlNFile(ShFileSystem fs, String vp, String name) {
            super(fs, vp, name);
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isZeroFile() {
            return true;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return IOs.NULL_INPUT;
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            return new PrintStream(IOs.NULL_OUTPUT);
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public ShStat getStat() {
            ShStat r = new ShStat();
            int f = 0;
            r.setFilename(this.virtualpath);
            r.setMtime(this.getLastModified());
            r.setSize(0L);
            f |= this.isDirectory() ? 8 : 0;
            f |= this.isExecutable() ? 4 : 0;
            f |= this.isWritable() ? 2 : 0;
            r.setFlags(f |= this.isReadable() ? 1 : 0);
            return r;
        }
    }

    private static class XmlRDir
    extends SpecialDir {
        private boolean subdir;
        private boolean create;
        private File file;

        public XmlRDir(ShFileSystem fs, String virtualpath, String name, File file, boolean subdir, boolean create) {
            super(fs, virtualpath, name);
            this.file = file;
            this.subdir = subdir;
            this.create = create;
        }

        @Override
        ShFile getFile(String name) {
            File[] l;
            File[] fileArray = l = this.file.listFiles();
            int n = l.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(name)) {
                    if (f.isFile()) {
                        return new XmlRFile(this.filesystem, this.joinpath(f.getName()), f.getName(), f);
                    }
                    if (this.subdir && f.isDirectory()) {
                        return new XmlRDir(this.filesystem, this.joinpath(f.getName()), f.getName(), f, this.subdir, this.create);
                    }
                }
                ++n2;
            }
            if (this.create) {
                return new XmlRFile(this.filesystem, this.joinpath(name), name, new File(this.file, name));
            }
            return null;
        }

        @Override
        public boolean isReadable() {
            return this.file.canRead();
        }

        @Override
        public boolean isWritable() {
            return this.file.canWrite();
        }

        @Override
        public boolean isHidden() {
            return this.file.isHidden();
        }

        @Override
        public long getLastModified() {
            return this.file.lastModified();
        }

        @Override
        public Collection<ShFile> getFiles() {
            File[] l;
            ArrayList<ShFile> r = new ArrayList<ShFile>();
            File[] fileArray = l = this.file.listFiles();
            int n = l.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    r.add(new XmlRFile(this.filesystem, this.joinpath(f.getName()), f.getName(), f));
                } else if (this.subdir && f.isDirectory()) {
                    r.add(new XmlRDir(this.filesystem, this.joinpath(f.getName()), f.getName(), f, this.subdir, this.create));
                }
                ++n2;
            }
            return r;
        }

        @Override
        public void setLastModified(long time) {
            this.file.setLastModified(time);
        }

        @Override
        public ShStat getStat() {
            ShStat r = new ShStat();
            int f = 0;
            r.setFilename(this.virtualpath);
            r.setMtime(this.file.lastModified());
            r.setSize(this.file.length());
            f |= this.isDirectory() ? 8 : 0;
            f |= this.isExecutable() ? 4 : 0;
            f |= this.isWritable() ? 2 : 0;
            r.setFlags(f |= this.isReadable() ? 1 : 0);
            return r;
        }
    }

    private static class XmlRFile
    extends SpecialFile {
        private File file;

        public XmlRFile(ShFileSystem fs, String vp, String name, File file) {
            super(fs, vp, name);
            this.file = file;
        }

        @Override
        public boolean isExecutable() {
            return this.file.canExecute();
        }

        @Override
        public boolean isReadable() {
            return this.file.canRead();
        }

        @Override
        public boolean isWritable() {
            return this.file.canWrite();
        }

        @Override
        public boolean isZeroFile() {
            return this.file.length() == 0L;
        }

        @Override
        public long getLastModified() {
            return this.file.lastModified();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            return new PrintStream(new FileOutputStream(this.file, append));
        }

        @Override
        public void setLastModified(long time) {
            this.file.setLastModified(time);
        }

        @Override
        public ShStat getStat() {
            return ShRealFile.getStat(this, this.virtualpath, this.file);
        }
    }

    private static class XmlSFile
    extends SpecialFile {
        private final long time = System.currentTimeMillis();
        private byte[] buffer;

        public XmlSFile(ShFileSystem fs, String vp, String name, String str) {
            super(fs, vp, name);
            this.buffer = str.getBytes();
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isZeroFile() {
            return this.buffer.length == 0;
        }

        @Override
        public long getLastModified() {
            return this.time;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.buffer);
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            throw new IOException();
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public ShStat getStat() {
            ShStat r = new ShStat();
            int f = 0;
            r.setFilename(this.virtualpath);
            r.setMtime(this.time);
            r.setSize(this.buffer.length);
            f |= this.isDirectory() ? 8 : 0;
            f |= this.isExecutable() ? 4 : 0;
            f |= this.isWritable() ? 2 : 0;
            r.setFlags(f |= this.isReadable() ? 1 : 0);
            return r;
        }
    }

    private static class XmlStdIO
    extends SpecialFile {
        private InputStream stdin;
        private PrintStream stdout;

        public XmlStdIO(ShFileSystem fs, String vp, String name, InputStream stdin, PrintStream stdout) {
            super(fs, vp, name);
            this.stdin = stdin;
            this.stdout = stdout;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return this.stdin != null;
        }

        @Override
        public boolean isWritable() {
            return this.stdout != null;
        }

        @Override
        public boolean isZeroFile() {
            return false;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.stdin == null) {
                throw new IOException();
            }
            return this.stdin;
        }

        @Override
        public PrintStream getPrintStream(boolean append) throws IOException {
            if (this.stdout == null) {
                throw new IOException();
            }
            return this.stdout;
        }

        @Override
        public void setLastModified(long time) {
        }

        @Override
        public ShStat getStat() {
            ShStat r = new ShStat();
            int f = 0;
            r.setFilename(this.virtualpath);
            r.setMtime(0L);
            r.setSize(0L);
            f |= this.isDirectory() ? 8 : 0;
            f |= this.isExecutable() ? 4 : 0;
            f |= this.isWritable() ? 2 : 0;
            r.setFlags(f |= this.isReadable() ? 1 : 0);
            return r;
        }
    }

    private static class XmlVDir
    extends SpecialDir {
        private Map<String, ShFile> files = new HashMap<String, ShFile>();
        private long last = System.currentTimeMillis();

        public XmlVDir(ShFileSystem fs, String virtualpath, String name) {
            super(fs, virtualpath, name);
        }

        private XmlVDir createSubdir(String name) {
            return new XmlVDir(this.filesystem, this.joinpath(name), name);
        }

        private XmlRFile createRFile(String name, File file) {
            return new XmlRFile(this.filesystem, this.joinpath(name), name, file);
        }

        private XmlRDir createRDir(String name, File file, boolean subdir, boolean create) {
            return new XmlRDir(this.filesystem, this.joinpath(name), name, file, subdir, create);
        }

        private XmlStdIO createStdIO(String name, InputStream stdin, PrintStream stdout) {
            return new XmlStdIO(this.filesystem, this.joinpath(name), name, stdin, stdout);
        }

        private XmlSFile createSFile(String name, String s) {
            return new XmlSFile(this.filesystem, this.joinpath(name), name, s);
        }

        private XmlJFile createJFile(String name, String res) {
            return new XmlJFile(this.filesystem, this.joinpath(name), name, res);
        }

        private XmlCFile createCFile(String name, List<SpecialFile> files) {
            return new XmlCFile(this.filesystem, this.joinpath(name), name, files);
        }

        private XmlNFile createNFile(String name) {
            return new XmlNFile(this.filesystem, this.joinpath(name), name);
        }

        private ShFile createFileByReflection(String c) throws ShConfigException {
            return (SpecialFile)ShFactory.getcls(c, this.filesystem, this.joinpath(this.name), this.name);
        }

        private ShFile createDirByReflection(String c) throws ShConfigException {
            return (SpecialDir)ShFactory.getcls(c, this.filesystem, this.joinpath(this.name), this.name);
        }

        @Override
        ShFile getFile(String name) {
            return this.files.get(name);
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long getLastModified() {
            return this.last;
        }

        @Override
        public Collection<ShFile> getFiles() {
            return this.files.values();
        }

        @Override
        public void setLastModified(long time) {
            this.last = time;
        }

        @Override
        public ShStat getStat() {
            ShStat r = new ShStat();
            int f = 0;
            r.setFilename(this.virtualpath);
            r.setMtime(this.last);
            r.setSize(765L);
            f |= this.isDirectory() ? 8 : 0;
            f |= this.isExecutable() ? 4 : 0;
            f |= this.isWritable() ? 2 : 0;
            r.setFlags(f |= this.isReadable() ? 1 : 0);
            return r;
        }
    }
}

