/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.misc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OptionIterator
implements Iterator<Character> {
    private String pattern;
    private Iterator<String> wrapped;
    private String option;
    private int index;
    private int errchar = -1;
    private boolean usePlus;
    String nopt;
    String now;
    private int ochar;
    private int ptr;
    private boolean oplus;
    private boolean plus;

    public OptionIterator(String pattern, boolean usePlus, Iterator<String> iterator) {
        this.pattern = pattern;
        this.wrapped = iterator;
        this.usePlus = usePlus;
        if (this._wnext() != null && this.now.startsWith("-") && !this.now.equals("-") && !this.now.equals("--")) {
            this.ptr = 1;
            this.plus = false;
            this._next();
        } else if (usePlus && this.now != null && this.now.startsWith("+")) {
            this.ptr = 1;
            this.plus = true;
            this._next();
        } else if (this.now != null && this.now.equals("--")) {
            this.ochar = -1;
            this._wnext();
        } else {
            --this.index;
            this.ochar = -1;
        }
    }

    public OptionIterator(String pattern, boolean usePlus, Iterable<String> x) {
        this(pattern, usePlus, x.iterator());
    }

    public OptionIterator(String pattern, boolean usePlus, String ... args) {
        this(pattern, usePlus, Arrays.asList(args).iterator());
    }

    public OptionIterator(String pattern, Iterable<String> x) {
        this(pattern, false, x.iterator());
    }

    public OptionIterator(String pattern, String ... args) {
        this(pattern, false, Arrays.asList(args).iterator());
    }

    private String _wnext() {
        ++this.index;
        if (this.wrapped.hasNext()) {
            this.now = this.wrapped.next();
            if (this.now == null) {
                this.now = "";
            }
        } else {
            this.now = null;
        }
        return this.now;
    }

    private boolean _option() {
        int i = this.pattern.indexOf(this.ochar);
        return ++i < this.pattern.length() && this.pattern.charAt(i) == ':';
    }

    void _next() {
        if (this.errchar >= 0) {
            return;
        }
        if (this.now == null) {
            this.ochar = -1;
        } else if (this.ptr < this.now.length()) {
            this.ochar = this.now.charAt(this.ptr++);
            if (this.ochar == 58 || this.pattern.indexOf(this.ochar) < 0) {
                this.errchar = this.ochar;
                this.ochar = 63;
            } else if (!this._option()) {
                this.nopt = null;
            } else if (this.ptr < this.now.length()) {
                this.nopt = this.now.substring(this.ptr);
                this.ptr = this.now.length();
            } else if (this._wnext() != null) {
                this.nopt = this.now;
                this.ptr = this.now.length();
            } else {
                this.ochar = -1;
                --this.index;
            }
        } else if (!this.wrapped.hasNext()) {
            this.ochar = -1;
            this.now = null;
        } else if (this._wnext().equals("--")) {
            this.ochar = -1;
            this._wnext();
        } else if (this.now.equals("-")) {
            this.ochar = -1;
        } else if (this.now.startsWith("-")) {
            this.ptr = 1;
            this.plus = false;
            this._next();
        } else if (this.usePlus && this.now.startsWith("+")) {
            this.ptr = 1;
            this.plus = true;
            this._next();
        } else {
            this.ochar = -1;
            --this.index;
        }
    }

    public String getArgument() {
        return this.option;
    }

    public int getIndex() {
        return this.ochar < 0 ? this.index + 1 : this.index;
    }

    public int getErrorOption() {
        return this.errchar;
    }

    public Iterator<String> filenameIterator() {
        if (this.ochar >= 0) {
            this.ochar = -1;
        }
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return OptionIterator.this.now != null;
            }

            @Override
            public String next() {
                String x = OptionIterator.this.now;
                if (OptionIterator.this.now == null) {
                    throw new NoSuchElementException();
                }
                OptionIterator.this._wnext();
                return x;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.ochar >= 0;
    }

    public char nextChar() {
        int x = this.ochar;
        this.oplus = this.plus;
        this.option = this.nopt;
        this.nopt = null;
        this.skip();
        return (char)x;
    }

    public void skip() {
        if (this.ochar < 0) {
            throw new NoSuchElementException();
        }
        if (this.errchar > 0) {
            this.errchar = -1;
        }
        this._next();
    }

    @Override
    public Character next() {
        return Character.valueOf(this.nextChar());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String getLookahead() {
        return this.now;
    }

    public boolean isPlus() {
        return this.oplus;
    }
}

