/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.misc;

import java.util.Arrays;
import net.morilib.unix.misc.WideCharSequence;
import net.morilib.unix.misc.WideStringBuilder;

public final class WideString
implements WideCharSequence {
    int[] wchars;

    public WideString(int[] wchars, int start, int count) {
        if (wchars == null) {
            throw new NullPointerException();
        }
        if (start < 0 || start >= wchars.length) {
            throw new IndexOutOfBoundsException(String.valueOf(start));
        }
        if (count < 0 || count > wchars.length - start) {
            throw new IndexOutOfBoundsException(String.valueOf(count));
        }
        this.wchars = new int[count];
        System.arraycopy(wchars, start, this.wchars, 0, count);
    }

    public WideString(int[] wchars) {
        this(wchars, 0, wchars.length);
    }

    private WideString(int[] wchars, boolean dummy) {
        this.wchars = wchars;
    }

    public WideString(String s) {
        int[] wc = new int[s.codePointCount(0, s.length())];
        int j = 0;
        int i = 0;
        while (i < s.length()) {
            int c;
            wc[j++] = c = s.codePointAt(i);
            i += c > 65535 ? 2 : 1;
        }
        this.wchars = wc;
    }

    public WideString(WideString s) {
        this(s.wchars, 0, s.length());
    }

    @Override
    public int charAt(int index) {
        if (index < 0 || index >= this.wchars.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.wchars[index];
    }

    @Override
    public int length() {
        return this.wchars.length;
    }

    @Override
    public WideCharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    private void chkrange(int start, int end) {
        if (start < 0 || start >= this.wchars.length) {
            throw new IndexOutOfBoundsException(String.valueOf(start));
        }
        if (end < 0 || end > this.wchars.length) {
            throw new IndexOutOfBoundsException(String.valueOf(end));
        }
        if (end < start) {
            throw new IndexOutOfBoundsException(String.valueOf(end));
        }
    }

    public WideString substring(int begin, int end) {
        this.chkrange(begin, end);
        return new WideString(this.wchars, begin, end - begin);
    }

    public WideString substring(int begin) {
        return this.substring(begin, this.wchars.length);
    }

    public WideString replace(WideString s, int begin, int end) {
        this.chkrange(begin, end);
        int[] wt = new int[this.wchars.length - (end - begin) + s.length()];
        System.arraycopy(this.wchars, 0, wt, 0, begin);
        System.arraycopy(s.wchars, 0, wt, begin, s.length());
        System.arraycopy(this.wchars, end, wt, begin + s.length(), this.wchars.length - end);
        return new WideString(wt, false);
    }

    public WideString concat(WideString s) {
        int[] wt = new int[this.length() + s.length()];
        System.arraycopy(this.wchars, 0, wt, 0, this.length());
        System.arraycopy(s.wchars, 0, wt, this.length(), s.length());
        return new WideString(wt, false);
    }

    public WideString concat(WideString ... strings) {
        WideStringBuilder b = new WideStringBuilder();
        WideString[] wideStringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            WideString s = wideStringArray[n2];
            b.append(s);
            ++n2;
        }
        return b.toWideString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.wchars);
    }

    public boolean equals(Object o) {
        if (o instanceof WideString) {
            return Arrays.equals(this.wchars, ((WideString)o).wchars);
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.wchars, 0, this.wchars.length);
    }
}

